% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Cat.R
\name{Cat}
\alias{Cat}
\alias{dcat}
\alias{rcat}
\alias{d,Cat,numeric-method}
\alias{r,Cat,numeric-method}
\alias{mean,Cat-method}
\alias{mode,Cat-method}
\alias{var,Cat-method}
\alias{entro,Cat-method}
\alias{finf,Cat-method}
\alias{llcat}
\alias{ll,Cat,numeric-method}
\alias{ecat}
\alias{mle,Cat,numeric-method}
\alias{me,Cat,numeric-method}
\alias{vcat}
\alias{avar_mle,Cat-method}
\alias{avar_me,Cat-method}
\title{Cat Distribution}
\usage{
Cat(prob = c(0.5, 0.5))

dcat(x, prob, log = FALSE)

rcat(n, prob)

\S4method{d}{Cat,numeric}(distr, x, log = FALSE)

\S4method{r}{Cat,numeric}(distr, n)

\S4method{mean}{Cat}(x)

\S4method{mode}{Cat}(x)

\S4method{var}{Cat}(x)

\S4method{entro}{Cat}(x)

\S4method{finf}{Cat}(x)

llcat(x, prob)

\S4method{ll}{Cat,numeric}(distr, x)

ecat(x, type = "mle", ...)

\S4method{mle}{Cat,numeric}(distr, x, dim = NULL, na.rm = FALSE)

\S4method{me}{Cat,numeric}(distr, x, dim = NULL, na.rm = FALSE)

vcat(prob, type = "mle")

\S4method{avar_mle}{Cat}(distr)

\S4method{avar_me}{Cat}(distr)
}
\arguments{
\item{prob}{numeric. Probability vector of success for each category.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Cat}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log}{logical. Should the logarithm of the probability be
returned?}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}

\item{distr}{an object of class \code{Cat}.}

\item{type}{character, case ignored. The estimator type (mle or me).}

\item{...}{extra arguments.}

\item{dim}{numeric. The probability vector dimension. See Details.}

\item{na.rm}{logical. Should the \code{NA} values be removed?}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The Categorical distribution is a discrete probability distribution that
describes the probability of a single trial resulting in one of \eqn{k}
possible categories. It is a generalization of the Bernoulli distribution
and a special case of the multinomial distribution with \eqn{n = 1}.
}
\details{
The probability mass function (PMF) of the categorical distribution is given
by: \deqn{ f(x; p) = \prod_{i=1}^k p_i^{x_i},}
subject to \eqn{ \sum_{i=1}^{k} x_i = n }.

The estimation of \code{prob} from a sample would by default return a vector of
probabilities corresponding to the categories that appeared in the sample and
0 for the rest. However, the parameter dimension cannot be uncovered by the
sample, it has to be provided separately. This can be done with the argument
\code{dim}. If \code{dim} is not supplied, the dimension will be retrieved from the
\code{distr} argument. Categories that did not appear in the sample will have 0
probabilities appended to the end of the prob vector.

Note that the actual dimension of the probability parameter vector is \code{k-1},
therefore the Fisher information matrix and the asymptotic variance -
covariance matrix of the estimators is of dimension \verb{(k-1)x(k-1)}.
}
\examples{
# -----------------------------------------------------
# Categorical Distribution Example
# -----------------------------------------------------

# Create the distribution
p <- c(0.1, 0.2, 0.7)
D <- Cat(p)

# ------------------
# dpqr Functions
# ------------------

d(D, 2) # density function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
mode(D) # Mode
var(D) # Variance
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llcat(x, p)

ecat(x, dim = 3, type = "mle")
ecat(x, dim = 3, type = "me")

mle(D, x)
me(D, x)
e(D, x, type = "mle")

mle("cat", dim = 3, x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vcat(p, type = "mle")
vcat(p, type = "me")

avar_mle(D)
avar_me(D)

v(D, type = "mle")
}
\seealso{
\code{\link[=dmultinom]{dmultinom()}}, \code{\link[=rmultinom]{rmultinom()}}
}
