\name{WL}
\alias{WL}
\title{Leaf Dry Weight (WL)}
\description{
The Leaf Dry Weight (WL) is estimated using the stem diameter at the lowest major living branch (DB) in centimeter unit, according to the allometric equations from the journal *"Allometric Equations for Estimating Above-Ground Biomass and Leaf Area of Planted Teak (Tectona grandis) Forests Under Agroforestry Management in East Java, Indonesia"* (Purwanto & Shiba, 2006). The equation has a coefficient of determination R^2 of 0.996, reflecting strong model fit. This estimation is most accurate when applied to trees in the same region as the study's sample, East Java, Indonesia. All measurements are in units of centimeter, and the output weight is in kilograms.}
\arguments{
  \item{db}{(numeric) The stem diameter at the lowest major living branch (DB) in centimeters.}
}
\usage{
WL(db)
}
\value{
The estimated leaf dry weight (WL) in kilograms.
}
\examples{
# Example: Estimating WL using stem diameter at the lowest major living branch (DB) = 30 cm
db <- 30  # Stem Diameter at the Lowest Major Living Branch in cm
WL_result <- WL(db)
print(WL_result)

# Example: Handling missing value
db <- NA  # Stem Diameter at the Lowest Major Living Branch in cm
WL_result <- WL(db)
print(WL_result)  # Should return NA because DB is NA
}