% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba.r
\name{grepls}
\alias{grepls}
\title{Search for objects in the environment}
\usage{
grepls(
  x,
  where = "all",
  ignore.case = TRUE,
  searchNames = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{\code{character} string used as a grep pattern}

\item{where}{\code{character} string compatible with \code{base::ls()} or if
installed, \code{AnnotationDbi::ls()}. A special value \code{"all"} will
search all environments on the search path \code{base::search()}
in order.}

\item{ignore.case}{\code{logical} indicating whether the pattern match
is case-insensitive.}

\item{searchNames}{\code{logical} indicating whether names should also
be searched, which is only relevant for \code{AnnDb} objects,
for example \code{org.Mm.egSYMBOL2EG} from the \code{org.Mm.eg.db}
Bioconductor package.}

\item{verbose}{\code{logical} indicating whether to print verbose output.}

\item{...}{additional parameters are ignored.}
}
\value{
\code{character} vector of matching object names, or if
\code{where="all"} it returns a named list
whose names indicate the search environment name, and whose
entries are matching object names within each environment.
}
\description{
Search for objects in the environment
}
\details{
This function searches the active R environment for an object name
using \code{vigrep()} (value, case-insensitive grep).
It is helpful when trying to find an object using a
substring, for example \code{grepls("statshits")}.
}
\examples{
# Find all objects named "grep", which should find
# base grep() and jamba::vigrep() among other results.
grepls("grep");

# Find objects in the local environment
allStatsHits <- c(1:12);
someStatsHits <- c(1:3);
grepls("statshits");
# shortcut way to search only the .GlobalEnv, the active local environment
grepls("statshits", 1);

# return objects with "raw" in the name
grepls("raw");

# Require "Raw" to be case-sensitive
grepls("Raw", ignore.case=FALSE)

}
\seealso{
Other jam grep functions: 
\code{\link{igrep}()},
\code{\link{igrepHas}()},
\code{\link{igrepl}()},
\code{\link{provigrep}()},
\code{\link{unigrep}()},
\code{\link{unvigrep}()},
\code{\link{vgrep}()},
\code{\link{vigrep}()}
}
\concept{jam grep functions}
