% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-clrange.R
\name{applyCLrange}
\alias{applyCLrange}
\title{Apply CL color range}
\usage{
applyCLrange(
  x,
  lightMode = NULL,
  Crange = getOption("jam.Crange"),
  Lrange = getOption("jam.Lrange"),
  Cgrey = getOption("jam.Cgrey", 5),
  fixYellow = TRUE,
  CLmethod = c("scale", "floor", "expand"),
  fixup = TRUE,
  ...
)
}
\arguments{
\item{x}{vector of R colors}

\item{lightMode}{\code{NULL} or \code{logical}. When \code{lightMode=NULL} then
\code{Crange} and \code{Lrange} values are used as-is; when \code{lightMode=TRUE}
or \code{lightMode=FALSE} then default values are used for \code{Crange} and
\code{Lrange} values, where \code{lightMode=TRUE} is intended for colors
to have contrast against a light/bright/white background,
and \code{lightMode=FALSE} is intended for colors to have contrast
against a dark background.}

\item{Crange}{\code{NULL} or \code{numeric} range with minimum and maximum allowed
values for the chroma (C) component.}

\item{Lrange}{\code{NUL}L or \code{numeric} range with minimum and maximum allowed
values for the luminance (L) component.}

\item{Cgrey}{\code{numeric} chroma (C) value, which defines grey colors at or
below this chroma. Any colors at or below the grey cutoff will have
their C values unchanged. This mechanism prevents converting black
to red, for example. To disable the effect, set \code{Cgrey=-1}.}

\item{fixYellow}{\code{logical} indicating whether to "fix" the darkening of
yellow, which otherwise turns to green. Instead, since JAM can,
JAM will make the yellow slightly more golden before darkening,
which is achieved by calling \code{fixYellowHue()}.}

\item{CLmethod}{\code{character} string indicating how to alter values
outside the respective \code{Crange} and \code{Lrange} ranges. "scale" will
rescale values only if any are outside of range, and will rescale
the full range of \code{c(Crange, Cvalues)} to \code{c(Crange)}. In this way,
only values outside the range are rescaled. "floor" will apply a
fixed cutoff, any values outside the range are set to equal the
range boundary itself. "expand" will rescale all values so the
range is equal to \code{Crange}.}

\item{fixup}{\code{logical} passed to \code{hcl2col()} and subsequently
to \code{colorspace::hex()} when converting colors outside the color
gamut (visible range.) When \code{fixup} is \code{NULL}, the \code{hcl2col()}
method applies its own aggressive technique to restrict the color
range.}

\item{...}{additional argyments are passed to \code{fixYellowHue()} when
\code{fixYellow} is \code{TRUE}.}
}
\value{
vector of colors after applying the chroma (C) and luminance (L)
ranges.
}
\description{
Restrict chroma (C) and luminance (L) ranges for a vector of R colors
}
\details{
This function is primarily intended to restrict the range of brightness
values so they contrast with a background color, particularly when the
background color may be bright or dark.

Note that output is slightly different when supplying one color,
compared to supplying a vector of colors. One color is simply
restricted to the \code{Crange} and \code{Lrange}. However, a vector of colors
is scaled within the ranges so that relative \code{C} and \code{L} values
are maintained, for visual comparison.

The C and L values are defined by \code{colorspace::polarLUV()}, where C is
typically restricted to \verb{0..100} and L is typically \verb{0..100}. For some
colors, values above 100 are allowed.

Values are restricted to the given numeric range using one of three
methods, set via the \code{CLmethod} argument.

As an example, consider what should be done when \code{Crange <- c(10,70)}
and the C values are \code{Cvalues <- c(50, 60, 70, 80)}.
\enumerate{
\item "floor" uses \code{jamba::noiseFloor()} to apply fixed cutoffs at the
minimum and maximum range. This method has the effect of making all
values outside the range into an equal final value.
\item "scale" will apply \code{jamba::normScale()} to rescale only values outside
the given range. For example, \code{c(Crange, Cvalues)} as the initial range,
it constrains values to \code{c(Crange)}.  This method has the effect of
maintaining the relative difference between values.
\item "expand" will simply apply \code{jamba::normScale()} to fit the values
to the minimum and maximum range values. This method has the effect of
forcing colors to fit the full numeric range, even when the original
differences between values were small.
}

In case (1) above, Cvalues will become \code{c(50, 60, 70, 70)}.
In case (2) above, Cvalues will become \code{c(44, 53, 61, 70)}
In case (3) above, Cvalues will become \code{c(10, 30, 50, 70)}

Note that colors with C (chroma) values less than \code{Cgrey} will not have
the C value changed, in order to maintain colors at a greyscale, without
colorizing them. Particularly for pure \code{grey}, which has \code{C=0}, but
is still required to have a hue H, it is important not to increase
\code{C}.
}
\examples{
cl <- c("red", "blue", "navy", "yellow", "orange");
cl_lite <- applyCLrange(cl, lightMode=TRUE);
cl_dark <- applyCLrange(cl, lightMode=FALSE);

# individual colors
cl_lite_ind <- sapply(cl, applyCLrange, lightMode=TRUE);
cl_dark_ind <- sapply(cl, applyCLrange, lightMode=FALSE);

# display colors
showColors(list(`input colors`=cl,
   `lightMode=TRUE, vector`=cl_lite,
   `lightMode=TRUE, individual`=cl_lite_ind,
   `lightMode=FALSE, vector`=cl_dark,
   `lightMode=FALSE, individual`=cl_dark_ind))
printDebug(cl, lightMode=TRUE);

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
