% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-colors-hsl.R
\name{hsl2col}
\alias{hsl2col}
\title{convert HCL to R color}
\usage{
hsl2col(
  x = NULL,
  H = NULL,
  S = NULL,
  L = NULL,
  alpha = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{\code{numeric} matrix of colors, with rownames \code{"H"}, \code{"S"}, \code{"L"},
or if not supplied it looks for vectors \code{H}, \code{S}, and \code{L} accordingly.}

\item{H, S, L}{\code{numeric} vectors supplied as an alternative to \code{x}, with
ranges 0 to 360, 0 to 100, and 0 to 100, respectively.}

\item{alpha}{\code{numeric} vector of alpha values, default NULL.
If not supplied, and if \code{x} is supplied as a matrix with
rowname \code{"alpha"}, then values will be used from \code{x["alpha",]}.}

\item{verbose}{\code{logical} indicating whether to print verbose output.}

\item{...}{other arguments are ignored.}
}
\value{
vector of R colors, or where the input was NA, then NA
values are returned in the same order.
}
\description{
Convert an HCL color matrix to vector of R hex colors
}
\details{
This function takes an HCL matrix,and converts to an R color using
the colorspace package \code{colorspace::polarLUV()} and \code{colorspace::hex()}.

When \code{model="hcl"} this function uses \code{farver::encode_colour()}
and bypasses \code{colorspace}. In future the \code{colorspace} dependency
will likely be removed in favor of using \code{farver}. In any event,
\code{model="hcl"} is equivalent to using \code{model="polarLUV"} and
\code{fixup=TRUE}, except that it should be much faster.
}
\examples{
# See col2hcl() for more extensive examples

# Prepare a basic HSL matrix
x_colors <- c(red="red",
   blue="blue",
   yellow="yellow",
   orange="#FFAA0066");
hslM <- col2hsl(x_colors);
hslM;

# Now convert back to R hex colors
colorV <- hsl2col(hslM);
colorV;

showColors(list(x_colors=x_colors,
   colorV=nameVector(colorV)));

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
