% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba.r
\name{getPlotAspect}
\alias{getPlotAspect}
\title{Get aspect ratio for coordinates, plot, or device}
\usage{
getPlotAspect(
  type = c("coords", "plot", "device"),
  parUsr = graphics::par("usr"),
  parPin = graphics::par("pin"),
  parDin = graphics::par("din"),
  ...
)
}
\arguments{
\item{type}{\code{character} type of aspect ratio to calculate.
\describe{
\item{"coords"}{calculates plot coordinate aspect ratio, which
is helpful for creating proper circular shapes, for example,
where the x-axis and y-axis ranges are very different. Note
that this calculation does also correct for margin sizes.}
\item{"plot"}{calculates plot aspect ratio, based upon the
actual size of the plot, independent of the numeric coordinate
range of the plot. This aspect ratio reflects the relative
visual height and width of the plot area, ignoring margins.}
\item{"device"}{calculates plot aspect ratio, based upon the
complete graphical device, i.e. the full space including all
panels, margins, and plot areas.}
}}

\item{parUsr, parPin, parDin}{\code{numeric} values equivalent to their
respective \code{graphics::par()} output, from \code{graphics::par("usr")},
\code{graphics::par("pin")}, and \code{graphics::par("din")}. Values can be
supplied directly, which among other things, prevents opening a
graphical device if one is not already opened. Any call to
\code{graphics::par()} will otherwise cause a graphic device to be opened,
which may not be desired on a headless R server.}

\item{...}{additional parameters are ignored.}
}
\value{
\code{numeric} plot aspect ratio for a plot device, of the requested
type, see the \code{type} argument.
}
\description{
Get aspect ratio for coordinates, plot, or device
}
\examples{
withr::with_par(list("mfrow"=c(2, 4), "mar"=c(1, 1, 1, 1)), {
for (i in 1:8) {
   nullPlot(plotAreaTitle=paste("Plot", i), xlim=c(1,100), ylim=c(1,10),
      doMargins=FALSE);
   graphics::axis(1, las=2);
   graphics::axis(2, las=2);
}
# device aspect inside the 2x4 layout
getPlotAspect("plot");
})
# device aspect outside the 2x4 layout
getPlotAspect("plot");

}
\seealso{
Other jam plot functions: 
\code{\link{adjustAxisLabelMargins}()},
\code{\link{coordPresets}()},
\code{\link{decideMfrow}()},
\code{\link{drawLabels}()},
\code{\link{groupedAxis}()},
\code{\link{imageByColors}()},
\code{\link{imageDefault}()},
\code{\link{minorLogTicksAxis}()},
\code{\link{nullPlot}()},
\code{\link{plotPolygonDensity}()},
\code{\link{plotRidges}()},
\code{\link{plotSmoothScatter}()},
\code{\link{shadowText}()},
\code{\link{shadowText_options}()},
\code{\link{showColors}()},
\code{\link{sqrtAxis}()},
\code{\link{usrBox}()}
}
\concept{jam plot functions}
