% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp.R
\name{qpSetupInfeasible}
\alias{qpSetupInfeasible}
\title{Configure QP environment for diagnostics}
\usage{
qpSetupInfeasible(env, rescale)
}
\arguments{
\item{env}{The LP environment}

\item{rescale}{boolean, set to \code{TRUE} if the MTR components
should be rescaled to improve stability in the LP/QP/QCP
optimization.}
}
\value{
Nothing, as this modifies an environment variable to save
    memory.
}
\description{
This function separates the shape constraints from the QP
environment. That way, the model can be solved without any shape
constraints, which is the primary cause of infeasibility. This is
done in order to check which shape constraints are causing the
model to be infeasible. The QP model must be passed as an
environment variable, under the entry \code{$model}. See
\code{\link{lpSetup}}.
}
