% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itcLiDARallo.R
\name{itcLiDARallo}
\alias{itcLiDARallo}
\title{Individual Tree Crowns segmentation with LiDAR data and crown diameter-height relationship}
\usage{
itcLiDARallo(
  X = NULL,
  Y = NULL,
  Z = NULL,
  epsg = NULL,
  resolution = 0.5,
  TRESHSeed = 0.55,
  TRESHCrown = 0.6,
  HeightThreshold = 2,
  lut = NULL,
  cw = 1
)
}
\arguments{
\item{X}{A column vector of x coordinates.}

\item{Y}{A column vector of y coordinates (it must have the same length as X).}

\item{Z}{A column vector of z coordinates (it must have the same length as X). Z must be normalized respect to the ground.}

\item{epsg}{The EPSG code of the reference system of the X,Y coordinates.}

\item{resolution}{The resolution of the raster on which the first segmentation is carried out.}

\item{TRESHSeed}{Growing threshold 1. It should be between 0 and 1.}

\item{TRESHCrown}{Growing threshold 2. It should be between 0 and 1.}

\item{HeightThreshold}{Minimum height of the trees.}

\item{lut}{Look up table. It should be made of two colums. The first column indicate the height in meters and the second the crown diameter in meters.}

\item{cw}{Weighting exponent used to increase the contrast in the CHM used to detect the local maxima (default cw=1).}
}
\value{
An object of the class SpatVector containing the delineated ITCs. The informaion for each ITC contained in the data frame are the X and Y coordinates position of the tree, the tree height in meters (Height_m) and its crown area in square meters (CA_m2).
}
\description{
The ITC delineation approach finds local maxima within a rasterized canopy height model (CHM), designates these as tree tops, then uses a decision tree method to grow individual crowns around the local maxima. The approach goes through the following steps: (1) a low-pass filter is applied to the rasterized CHM to smooth the surface and reduce the number of local maxima; (2) local maxima are located using a moving window with size that adapts inside a user defined range (minimum and maximum size) according the pixel height; a pixel of the CHM is labelled as local maxima if its z value is greater than all other z values in the window, and with z greater than some minimum height above-ground; (3) each local maximum is labelled as an 'initial region' around which a tree crown can grow; the heights of the four neighboring pixels are extracted from the CHM and these pixels are added to the region if their vertical distance from the local maximum is less than some user-defined percentage of the local-maximum height, and less than some user-defined maximum difference; this procedure is repeated for all the neighbors of cells now included in the region, and so on iteratively until no further pixels are added to the region; (4) from each region that had been identified the first-return ALS points are extracted (having first removed low elevation points), (5) a 2D convex hull is applied to these points, and the resulting polygons becomes the final ITCs.
}
\examples{
\dontrun{
data(lasData)

##Creation of the look-up-table

lut<-matrix(6,2,data=NA)
lut<-data.frame(lut)
names(lut)<-c("H","CD")

lut$H<-c(2,10,15,20,25,30)
lut$CD<-c(0.5,1,2,3,4,5)

## function takes a while to run
se<-itcLiDARallo(lasData$X,lasData$Y,lasData$Z,epsg=32632,lut=lut)
summary(se)
plot(se,axes=T)

## If we want to seperate the height of the trees by grayscales:

plot(se,col=gray((max(se$Height_m)-se$Height_m)/(max(se$Height_m)-min(se$Height_m))),axes=T)

## to save the data use rgdal function called writeOGR. For more help see rgdal package.

}
}
\references{
D. A. Coomes, M. Dalponte, T. Jucker, G. P. Asner, L. F. Banin, D. F.R.P. Burslem, S. L. Lewis, R. Nilus, O. L. Phillips, M.-H. Phua, L. Qie, "Area-based vs tree-centric approaches to mapping forest carbon in Southeast Asian forests from airborne laser scanning data," Remote Sensing of Environment, Vol. 194, Issue 1, pp. 77-88, June 2017.
}
\author{
Michele Dalponte
}
