% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{plot.idr}
\alias{plot.idr}
\title{Plot IDR predictions}
\usage{
\method{plot}{idr}(
  x,
  index = 1,
  bounds = TRUE,
  col.cdf = "black",
  col.bounds = "blue",
  lty.cdf = 1,
  lty.bounds = 3,
  xlab = "Threshold",
  ylab = "CDF",
  main = "IDR predictive CDF",
  ...
)
}
\arguments{
\item{x}{object of class \code{idr} (output of
\code{\link{predict.idrfit}}).}

\item{index}{index of the prediction in \code{x} for which a plot is desired.}

\item{bounds}{whether the bounds should be plotted or not (see
\code{\link{predict.idrfit}} for details about the meaning of the bounds).}

\item{col.cdf}{color of the predictive CDF.}

\item{col.bounds}{color of the bounds.}

\item{lty.cdf}{linetype of the predictive CDF.}

\item{lty.bounds}{linetype of the CDF bounds.}

\item{xlab}{label for x axis.}

\item{ylab}{label for y axis.}

\item{main}{main title.}

\item{...}{further arguments to \code{\link{plot.stepfun}} or
\code{\link{plot}}.}
}
\value{
The data based on which the plot is drawn (returned invisible).
}
\description{
Plot an IDR predictive CDF.
}
\examples{
data("rain")
require("graphics")

## Postprocess HRES and CTR forecast using data of 2 years

X <- rain[1:(2 * 365), c("HRES", "CTR"), drop = FALSE]
y <- rain[1:(2 * 365), "obs"]

## Fit IDR and plot the predictive CDF when the HRES forecast is 1 mm and
## CTR is 0 mm

fit <- idr(y = y, X = X)
pred <- predict(fit, data = data.frame(HRES = 1, CTR = 0))
plot(pred)
}
\seealso{
\code{\link{predict.idrfit}}
}
