% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partialOrders.R
\name{neighborPoints}
\alias{neighborPoints}
\title{Neighbor points with respect to componentwise order}
\usage{
neighborPoints(x, X, orderX)
}
\arguments{
\item{x}{numeric matrix with at least two columns.}

\item{X}{numeric matrix with same number of columns as \code{x}.}

\item{orderX}{output of \code{compOrd(X)}.}
}
\value{
Lists of length \code{nrow(x)} giving for each \code{x[i, ]} the indices
of the smaller and the greater neighbor points within the rows of \code{X}.
}
\description{
Find the neighbor points of the rows of a matrix \code{x} within
the rows of \code{X} in the componentwise partial order. That is, for each
row \code{x[i, ]}, find all indices \code{k} such that either \code{x[i, ] >=
X[k, ]} in all components and \code{x[i, ] >= X[j, ] >= X[k, ]} holds for no
\code{j} different from \code{k}, or \code{x[i, ] <= X[k, ]} in all
components and \code{x[i ,] <= X[j, ] <= X[k, ]} holds for no \code{j}
different from \code{k}.
}
\keyword{internal}
