% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irtoys-package.R
\docType{package}
\name{irtoys-package}
\alias{irtoys-package}
\alias{irtoys}
\title{Estimate and plot IRT models for binary responses}
\description{
\tabular{ll}{
Package: \tab irtoys\cr
Type: \tab Package\cr
Version: \tab 0.2.0\cr
Date: \tab 2016-01-30\cr
License: \tab GPL (>= 2)\cr
LazyLoad: \tab yes\cr
LazyData: \tab yes\cr
}
}
\details{
The \code{irtoys} package contains a bunch of functions potentially useful
to those teaching or learning Item Response Theory (IRT). R being 
particularly good at graphics, there is a rich array of plotting 
functions to visualize IRT models or assess their fit. Ability estimates 
can be estimated by MLE, BME, EAP, WLE. Various IRT scaling methods are supported: 
MM, MS, Stocking-Lord, and Hebaera. Last not least, \code{irtoys} may be
the only package to estimate Haberman's interaction model, although a new and
more powerful package is in the making.

Currently, there are several R packages that can estimate the item parameters
in various uni- and multidimensional IRT models, but only several years ago one
had to use stand-alone programs that had wildly different and
often unwieldy user interfaces. Besides, no single program does everything
one needs. One of the original purposes of \code{irtoys} was to provide a 
simple and unified interface to some of the most basic
functions in ICL, BILOG, and R's own \code{ltm}, such that beginners could
concentrate on learning IRT rather than syntaxes. Once that these steps 
have been made, those wishing to take
advantage of the full functionality of ICL, BILOG & Co. must still master
the syntax of their program of choice.

To take full advantage of \code{irtoys}, some IRT software is needed.
Package \code{ltm} is automatically loaded.  ICL by Brad Hanson can be
downloaded from his site, \url{http://www.openirt.com/b-a-h/software/}.
Executables and a very detailed manual (not needed to use ICL with 
\code{irtoys} are provided for Windows, Linux, and Macintosh. The Mac
version probably does not work with the current OS versions but I still
use the Windows and Linux versions without any problem.


BILOG is commercial software sold by SSI ---
see \url{https://ssicentral.com/} for further detail.

On Windows, make sure that the executable files (\code{icl.exe} for ICL,
\code{BLM1.EXE}, \code{BLM2.EXE}, and \code{BLM3.EXE} for BILOG) are located
in a directory that is included in the PATH variable.  On Linux, BILOG,
being a Windows program, is run with \code{wine}, and should also be on a
path where wine can find it.  On my machine, I have simply put the three
files in \code{~/.wine/drive_c/windows/}. It seems that new versions of wine
expect them to be explicitly tagged as executable. On Macintosh, at least
\code{ltm} should work in all cases.

NOTE: Starting with version 0.2.0, function \code{est} returns a list of three
elements: \code{est} contains the parameter estimates and is thus identical
to the output in earlier versions, \code{se} contains the standard errors,
in a similar format, and \code{vcm} contains the variance-covariance matrices
(NULL when using ICL). When passing item parameters to another function that
only needs the estimates, \code{irf(ip)} and 
\code{irf(ip$est)} can be used interchangeably. This facilitates using simulated
item parameters. A function that does require the complete object is \code{}. 

Also, function \code{itf} now returns item fit statistics 
as a vector rather than a list. Finally, since most of the functions in \code{irtoys}
have been written with the "logistic" metric in mind (i.e., \eqn{a_j(\theta_i-b_j)}
rather than \eqn{1.7a^*_j(\theta_i-b_j)}, function \code{est} now estimates item 
parameters only in the logistic metric.
}
\references{
S. E. Embretson and S. P. Reise (2000), Item Response Theory for
Psychologists, Lawrence Erlbaum Associates, Mahwah, NJ
}
\author{
Ivailo Partchev <partchev@gmail.com>
}
\keyword{models}
