% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc2x3.r
\name{pval.ICC2r.inter}
\alias{pval.ICC2r.inter}
\title{P-values of ICC(2,1) under Model 2 with subject-rater interaction, for 6 specific null values.}
\usage{
pval.ICC2r.inter(dfra)
}
\arguments{
\item{dfra}{This is a data frame containing 3 columns or more.  The first column contains subject numbers (there could be duplicates
if a subject was assigned multiple ratings) and each of the remaining columns is associated with a particular rater and contains its
numeric ratings.}
}
\value{
This function returns a vector containing 6 p-values associated with the 6 null values 0,0.1,0.3,0.5,0.7,0.9.
}
\description{
This function computes 6 p-values for the Intraclass Correlation Coefficient (ICC) used as a measure of inter-rater reliability
under the random factorial ANOVA model (Model 2) with subject-rater interaction. Each of the 6 p-values is associated with one
of the null values 0,0.1,0.3,0.5,0.7,0.9.
}
\examples{
#iccdata1 is a small dataset that comes with the package. Use it as follows:
library(irrICC)
iccdata1 #see what the iccdata1 dataset looks like
pval.ICC2r.inter(iccdata1)
}
\references{
Gwet, K.L. (2014): \emph{Handbook of Inter-Rater Reliability - 4th ed.} chapter 9, section 9.3.1, equation
9.3.6. Advanced Analytics, LLC.
}
