% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ironseed.R
\name{ironseed}
\alias{ironseed}
\alias{set_ironseed}
\alias{get_ironseed}
\alias{create_ironseed}
\alias{auto_ironseed}
\alias{is_ironseed}
\alias{is_ironseed_str}
\alias{as_ironseed}
\alias{parse_ironseed_str}
\title{Ironseed: Improved Random Number Generator Seeding}
\usage{
ironseed(
  ...,
  set_seed = TRUE,
  quiet = FALSE,
  methods = c("dots", "args", "env", "auto", "null")
)

set_ironseed(x, ..., quiet = FALSE)

get_ironseed()

create_ironseed(x)

auto_ironseed()

is_ironseed(x)

is_ironseed_str(x)

as_ironseed(x)

parse_ironseed_str(x)
}
\arguments{
\item{...}{objects}

\item{set_seed}{a logical indicating whether to initialize \code{.Random.seed}.}

\item{quiet}{a logical indicating whether to silence messages.}

\item{methods}{a character vector.}

\item{x}{a string, ironseed, list, or other object}
}
\value{
An ironseed. If \code{.Random.seed} was initialized, the ironseed used
will be returned invisibly.
}
\description{
An ironseed is a 256-bit hash digest constructed from a variable-length
input sequence and can be used to generate a variable-length output sequence
of seeds, including initializing R's built-in random number generator.
\itemize{
\item \code{ironseed()} creates an ironseed from user supplied objects, from external
arguments, or automatically from multiple sources of entropy on the local
system. It also initializes R's built-in random number generator from an
ironseed.
\item \code{get_ironseed()} returns the ironseed most recently used to initialize
\code{.Random.seed}.
\item \code{set_ironseed()} is a wrapper around \code{ironseed()} for initializing
\code{.Random.seed} with user-supplied data.
\item \code{create_ironseed()} constructs an ironseed from a list of seed objects,
following the rules described below. \code{auto_ironseed()} constructs an
ironseed from multiple sources of entropy on the local system.
\item \code{is_ironseed()} tests whether an object is an ironseed, and
\code{is_ironseed_str()} tests if it is a string representing and ironseed.
\item \code{as_ironseed()} casts an object to an ironseed, and \code{parse_ironseed_str()}
parses a string to an ironseed.
}
}
\details{
Ironseeds have a specific string representation, e.g.
"rBQSjhjYv1d-z8dfMATEicf-sw1NSWAvVDi-bQaKSKKQmz1", where each element is a
64-bit number encoded in little-endian base58 format.

Ironseed generates an ironseed from an input sequence according to the
methods included in \code{methods}. When generating an ironseed, \code{ironseed()}
tries the listed methods starting from the first value and continuing
until it can generate an ironseed. If no method works, an error will be
raised.
\itemize{
\item dots: Use the values passed as \code{...} to construct an ironseed. Most atomic
types and lists of atomic types can be used. \code{ironseed()} and
\code{ironseed(NULL)} are considered empty inputs and the next method will be
tried.
\item args: Use command line arguments to construct an ironseed. Any arguments
that begins with \verb{--seed=} or \verb{-seed=} will be used as strings, after the
argument names are trimmed. If no matching arguments are found, the next
method will be tried.
\item env: Use the value of the environmental variable "IRONSEED" as a scalar
character to construct an ironseed. If this variable doesn't exist or is set
to an empty string, the next method will be tried.
\item auto: Use multiple sources of entropy from the system to generate an
ironseed. This method always constructs an ironseed.
\item null: Generate a "default" ironseed using no input. This method always
constructs an ironseed.
}

If the input sequence has one value and it is an ironseed object, it is used
as is. If the input sequence is a scalar character that matches an ironseed
string, it is parsed to an ironseed. Otherwise, the input sequence is hashed
to create an ironseed.

An ironseed is a finite-entropy (or fixed-entropy) hash digest that can be
used to generate an unlimited sequence of seeds for initializing the state of
a random number generator. It is inspired by the work of M.E. O’Neill and
others.

An ironseed is a 256-bit hash digest constructed from a variable-length
sequence of 32-bit inputs. Each ironseed consists of eight 32-bit
sub-digests. The sub-digests are 32-bit multilinear hashes that accumulate
entropy from the input sequence. Each input is included in every sub-digest.
The coefficients for the multilinear hashes are generated by a Weyl sequence.

Multilinear hashes are also used to generate an output seed sequence from an
ironseed. Each 32-bit output value is generated by uniquely hashing the
sub-digests. The coefficients for the output are generated by a second
Weyl sequence.

To improve the observed randomness of each hash output, bits are mixed using
a finalizer adapted from SplitMix64. With the additional mixing from the
finalizer, the output seed sequence passes PractRand tests.
}
\examples{
\dontshow{
oldseed <- ironseed::get_random_seed()
}

# Generate an ironseed with user supplied data.
# This will initialize an uninitialized `.Random.seed`.
ironseed::ironseed("Experiment", 20251031, 1)

# Generate an ironseed automatically and force initialize
ironseed::ironseed(set_seed = TRUE)

# Return last used ironseed.
ironseed::get_ironseed()

\dontshow{
ironseed::set_random_seed(oldseed)
}

}
\references{
\itemize{
\item O’Neill (2015) Developing a seed_seq Alternative.
\url{https://www.pcg-random.org/posts/developing-a-seed_seq-alternative.html}
\item O’Neill (2015) Simple Portable C++ Seed Entropy.
\url{https://www.pcg-random.org/posts/simple-portable-cpp-seed-entropy.html}
\item O’Neill (2015) Random-Number Utilities.
\url{https://gist.github.com/imneme/540829265469e673d045}
\item Lemire and Kaser (2018) Strongly universal string hashing is fast.
\url{https://arxiv.org/pdf/1202.4961}
\item Steele et al. (2014) Fast splittable pseudorandom number generators.
\doi{10.1145/2714064.2660195}
\item Weyl Sequence \url{https://en.wikipedia.org/wiki/Weyl_sequence}
\item PractRand \url{https://pracrand.sourceforge.net/}
}
}
\seealso{
\link{set.seed} \link{.Random.seed}
}
