/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.plots;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.PrintStream;
import java.util.Vector;
import org.rosuda.ibase.Commander;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.Dependent;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.SVarObj;
import org.rosuda.ibase.toolkit.Axis;
import org.rosuda.ibase.toolkit.EzMenu;
import org.rosuda.ibase.toolkit.PGSCanvas;
import org.rosuda.ibase.toolkit.WinTracker;
import org.rosuda.pograss.PoGraSS;
import org.rosuda.util.SpacingPanel;
import org.rosuda.util.Tools;

public class LineCanvas
extends PGSCanvas
implements Dependent,
MouseListener,
MouseMotionListener,
KeyListener,
ActionListener,
Commander {
    public static final int LT_DIRECT = 0;
    public static final int LT_RECT = 1;
    int type = 0;
    SVar[] v;
    SMarker m;
    boolean showLabels = true;
    boolean jitter = false;
    boolean selRed = false;
    boolean drawBackline = false;
    Axis[] A;
    int x1;
    int y1;
    int x2;
    int y2;
    boolean drag;
    public boolean ignoreMarker = false;
    MenuItem MIlabels = null;
    int X;
    int Y;
    int W;
    int H;
    int TW;
    int TH;
    double totMin;
    double totMax;

    public LineCanvas(int n, Frame frame, SVar sVar, SVar[] sVarArray, SMarker sMarker) {
        super(n, 3);
        int n2;
        this.setFrame(frame);
        this.v = new SVar[sVarArray.length + 1];
        this.A = new Axis[2];
        this.m = sMarker;
        if (this.m != null) {
            this.m.addDepend(this);
        }
        String string = null;
        for (n2 = 0; n2 < sVarArray.length; ++n2) {
            if (n2 == 0) {
                this.totMin = sVarArray[n2].getMin();
                this.totMax = sVarArray[n2].getMax();
            } else {
                if (sVarArray[n2].getMin() < this.totMin) {
                    this.totMin = sVarArray[n2].getMin();
                }
                if (sVarArray[n2].getMax() > this.totMax) {
                    this.totMax = sVarArray[n2].getMax();
                }
            }
            string = string == null ? sVarArray[n2].getName() : string + "," + sVarArray[n2].getName();
            this.v[n2 + 1] = sVarArray[n2];
        }
        this.A[1] = new Axis(null, 1, 0);
        this.A[1].setValueRange(this.totMin, this.totMax - this.totMin);
        this.A[1].addDepend(this);
        if (sVar == null) {
            sVar = new SVarObj("index.LC");
            for (n2 = 1; n2 <= this.v[1].size(); ++n2) {
                sVar.add(new Integer(n2));
            }
            this.setTitle("Series plot of " + string);
        } else {
            this.setTitle("Series plot of " + sVar.getName() + " vs " + string);
        }
        frame.setTitle(this.getTitle());
        this.v[0] = sVar;
        this.A[0] = new Axis(this.v[0], 0, this.v[0].isCat() ? 1 : 0);
        this.A[0].addDepend(this);
        this.A[0].setValueRange(this.v[0].getMin() - (this.v[0].getMax() - this.v[0].getMin()) / 20.0, (this.v[0].getMax() - this.v[0].getMin()) * 1.1);
        this.setBackground(Common.backgroundColor);
        this.drag = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        frame.addKeyListener(this);
        String[] stringArray = new String[]{"+", "File", "~File.Graph", "~Edit", "+", "View", "@RRotate", "rotate", "@LHide labels", "labels", "!HToggle hilight. style", "selRed", "@JToggle jittering", "jitter", "@BToggle back-lines", "backlines", "-", "Set X Range ...", "XrangeDlg", "Set Y Range ...", "YrangeDlg", "~Window", "0"};
        EzMenu.getEzMenu(frame, this, stringArray);
        this.MIlabels = EzMenu.getItem(frame, "labels");
        MenuItem menuItem = EzMenu.getItem(frame, "rotate");
        if (menuItem != null) {
            menuItem.setEnabled(false);
        }
    }

    public LineCanvas(Frame frame, SVar sVar, SVar[] sVarArray, SMarker sMarker) {
        this(0, frame, sVar, sVarArray, sMarker);
    }

    public Axis getXAxis() {
        return this.A[0];
    }

    public Axis getYAxis() {
        return this.A[1];
    }

    public Dimension getMinimumSize() {
        return new Dimension(60, 50);
    }

    public void rotate() {
    }

    public void setLineType(int n) {
        this.type = n;
        this.setUpdateRoot(0);
        this.repaint();
    }

    public void Notifying(NotifyMsg notifyMsg, Object object, Vector vector) {
        this.setUpdateRoot(notifyMsg.getMessageID() == 4096 ? 0 : 0);
        this.repaint();
    }

    public void paintPoGraSS(PoGraSS poGraSS) {
        int n;
        double d;
        int n2;
        int n3;
        int n4;
        Rectangle rectangle = this.getBounds();
        poGraSS.setBounds(rectangle.width, rectangle.height);
        poGraSS.begin();
        poGraSS.defineColor("white", 255, 255, 255);
        if (this.selRed) {
            poGraSS.defineColor("marked", 255, 0, 0);
        } else {
            poGraSS.defineColor("marked", 128, 255, 128);
        }
        poGraSS.defineColor("black", 0, 0, 0);
        poGraSS.defineColor("outline", 0, 0, 0);
        poGraSS.defineColor("point", 0, 0, 128);
        poGraSS.defineColor("red", 255, 0, 0);
        poGraSS.defineColor("line", 0, 0, 128);
        poGraSS.defineColor("lines", 96, 96, 255);
        poGraSS.defineColor("selText", 255, 0, 0);
        poGraSS.defineColor("selBg", 255, 255, 192);
        poGraSS.defineColor("splitRects", 128, 128, 255);
        Dimension dimension = this.getSize();
        if (dimension.width != this.TW || dimension.height != this.TH) {
            int n5 = dimension.width;
            n4 = dimension.height;
            this.TW = n5;
            this.TH = n4;
            int n6 = 45;
            n3 = 30;
            n2 = 0;
            int n7 = n5 - n6 - 10;
            int n8 = n4 - n3 - 10;
            this.X = n6;
            this.W = n7;
            this.A[0].setGeometry(0, this.X, this.W);
            this.H = n8;
            this.A[1].setGeometry(1, n3, this.H);
            this.Y = this.TH - n3 - n8;
        }
        if (this.TW < 50 || this.TH < 50) {
            poGraSS.setColor("red");
            poGraSS.drawLine(0, 0, this.TW, this.TH);
            poGraSS.drawLine(0, this.TH, this.TW, 0);
            return;
        }
        poGraSS.setColor("white");
        poGraSS.fillRect(this.X, this.Y, this.W, this.H);
        poGraSS.setColor("black");
        poGraSS.drawLine(this.X, this.Y, this.X, this.Y + this.H);
        poGraSS.drawLine(this.X, this.Y + this.H, this.X + this.W, this.Y + this.H);
        double d2 = this.A[0].getSensibleTickDistance(50, 26);
        for (d = this.A[0].getSensibleTickStart(d2); d < this.A[0].vBegin + this.A[0].vLen; d += d2) {
            n2 = this.A[0].getValuePos(d);
            poGraSS.drawLine(n2, this.Y + this.H, n2, this.Y + this.H + 5);
            if (!this.showLabels) continue;
            poGraSS.drawString(this.v[0].isCat() ? this.v[0].getCatAt((int)d).toString() : this.A[0].getDisplayableValue(d), n2 - 5, this.Y + this.H + 20);
        }
        d2 = this.A[1].getSensibleTickDistance(50, 18);
        for (d = this.A[1].getSensibleTickStart(d2); d < this.A[1].vBegin + this.A[1].vLen; d += d2) {
            n2 = this.TH - this.A[1].getValuePos(d);
            poGraSS.drawLine(this.X - 5, n2, this.X, n2);
            if (!this.showLabels) continue;
            poGraSS.drawString(this.v[1].isCat() ? Common.getTriGraph(this.v[1].getCatAt((int)d).toString()) : this.A[1].getDisplayableValue(d), this.X - 25, n2 + 5);
        }
        poGraSS.setColor("line");
        for (n = 1; n < this.v.length; ++n) {
            if (n == 2) {
                poGraSS.setColor(255, 0, 0);
            }
            if (n == 3) {
                poGraSS.setColor(0, 0, 255);
            }
            if (n == 4) {
                poGraSS.setColor(128, 0, 128);
            }
            if (n == 5) {
                poGraSS.setColor(0, 128, 128);
            }
            if (n == 6) {
                poGraSS.setColor(128, 128, 0);
            }
            if (n == 7) {
                poGraSS.setColor(0, 0, 0);
            }
            n4 = 0;
            for (int i = 1; i < this.v[0].size() && i < this.v[n].size(); ++i) {
                n3 = this.A[0].getCasePos(i - 1);
                n2 = this.A[0].getCasePos(i);
                if (!this.drawBackline && n2 < n3 || this.v[n].at(i) == null || this.v[n].at(i - 1) == null) continue;
                if (this.m.at(i) != n4) {
                    int n9 = n4 = n4 == 0 ? 1 : 0;
                    if (n4 != 0 && !this.ignoreMarker) {
                        poGraSS.setColor("marked");
                    } else {
                        if (n == 1) {
                            poGraSS.setColor("line");
                        }
                        if (n == 2) {
                            poGraSS.setColor(255, 0, 0);
                        }
                        if (n == 3) {
                            poGraSS.setColor(0, 0, 255);
                        }
                        if (n == 4) {
                            poGraSS.setColor(128, 0, 128);
                        }
                        if (n == 5) {
                            poGraSS.setColor(0, 128, 128);
                        }
                        if (n == 6) {
                            poGraSS.setColor(128, 128, 0);
                        }
                        if (n > 6) {
                            poGraSS.setColor(0, 0, 0);
                        }
                    }
                }
                if (this.type == 0) {
                    poGraSS.drawLine(this.A[0].getCasePos(i - 1), this.TH - this.A[1].getValuePos(this.v[n].atD(i - 1)), this.A[0].getCasePos(i), this.TH - this.A[1].getValuePos(this.v[n].atD(i)));
                    continue;
                }
                poGraSS.drawLine(this.A[0].getCasePos(i - 1), this.TH - this.A[1].getValuePos(this.v[n].atD(i - 1)), this.A[0].getCasePos(i), this.TH - this.A[1].getValuePos(this.v[n].atD(i - 1)));
                poGraSS.drawLine(this.A[0].getCasePos(i), this.TH - this.A[1].getValuePos(this.v[n].atD(i - 1)), this.A[0].getCasePos(i), this.TH - this.A[1].getValuePos(this.v[n].atD(i)));
            }
        }
        this.nextLayer(poGraSS);
        if (this.drag) {
            this.nextLayer(poGraSS);
            n = this.A[0].clip(this.x1);
            n4 = this.TH - this.A[1].clip(this.TH - this.y1);
            int n10 = this.A[0].clip(this.x2);
            n3 = this.TH - this.A[1].clip(this.TH - this.y2);
            if (n > n10) {
                n2 = n;
                n = n10;
                n10 = n2;
            }
            if (n4 > n3) {
                n2 = n4;
                n4 = n3;
                n3 = n2;
            }
            poGraSS.setColor("black");
            poGraSS.drawRect(n, n4, n10 - n, n3 - n4);
        }
        poGraSS.end();
        this.setUpdateRoot(3);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.x1 = n - 2;
        this.y1 = n2 - 2;
        this.x2 = n + 3;
        this.y2 = n2 + 3;
        this.drag = true;
        this.mouseReleased(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.x1 = mouseEvent.getX();
        this.y1 = mouseEvent.getY();
        this.drag = true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = this.x1;
        int n2 = this.y1;
        int n3 = this.x2;
        int n4 = this.y2;
        if (this.x1 > this.x2) {
            n3 = this.x1;
            n = this.x2;
        }
        if (this.y1 > this.y2) {
            n4 = this.y1;
            n2 = this.y2;
        }
        Rectangle rectangle = new Rectangle(n, n2, n3 - n, n4 - n2);
        boolean bl = false;
        if (mouseEvent.isControlDown()) {
            bl = true;
        }
        if (!mouseEvent.isShiftDown()) {
            this.m.selectNone();
        }
        this.drag = false;
        this.m.NotifyAll(new NotifyMsg(this.m, 4096));
        this.setUpdateRoot(1);
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.drag) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n != this.x2 || n2 != this.y2) {
                this.x2 = n;
                this.y2 = n2;
                this.setUpdateRoot(2);
                this.repaint();
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == 'l') {
            this.run(this, "labels");
        }
        if (keyEvent.getKeyChar() == 'P') {
            this.run(this, "print");
        }
        if (keyEvent.getKeyChar() == 'X') {
            this.run(this, "exportPGS");
        }
        if (keyEvent.getKeyChar() == 'C') {
            this.run(this, "exportCases");
        }
        if (keyEvent.getKeyChar() == 'e') {
            this.run(this, "selRed");
        }
        if (keyEvent.getKeyChar() == 'j') {
            this.run(this, "jitter");
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public Object run(Object object, String string) {
        Object object2;
        super.run(object, string);
        if (this.m != null) {
            this.m.run(object, string);
        }
        if (string == "rotate") {
            this.rotate();
        }
        if (string == "labels") {
            this.showLabels = !this.showLabels;
            this.MIlabels.setLabel(this.showLabels ? "Hide labels" : "Show labels");
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (string == "print") {
            this.run(object, "exportPS");
        }
        if (string == "exit") {
            WinTracker.current.Exit();
        }
        if (string == "selRed") {
            this.selRed = !this.selRed;
            this.setUpdateRoot(1);
            this.repaint();
        }
        if (string == "jitter") {
            this.jitter = !this.jitter;
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (string == "backlines") {
            this.drawBackline = !this.drawBackline;
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (string == "YrangeDlg" || string == "XrangeDlg") {
            int n = string == "YrangeDlg" ? 1 : 0;
            Dialog dialog = this.intDlg = new Dialog(this.myFrame, n == 1 ? "Y range" : "X range", true);
            PGSCanvas.IDlgCL iDlgCL = new PGSCanvas.IDlgCL(this);
            dialog.setBackground(Color.white);
            dialog.setLayout(new BorderLayout());
            dialog.add((Component)new SpacingPanel(), "West");
            dialog.add((Component)new SpacingPanel(), "East");
            object2 = new Panel();
            ((Container)object2).setLayout(new FlowLayout());
            Button button = new Button("OK");
            ((Container)object2).add(button);
            Button button2 = new Button("Cancel");
            ((Container)object2).add(button2);
            dialog.add((Component)object2, "South");
            dialog.add((Component)new Label(" "), "North");
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout());
            dialog.add(panel);
            panel.add(new Label("start: "));
            TextField textField = new TextField("" + this.A[n].vBegin, 6);
            TextField textField2 = new TextField("" + (this.A[n].vBegin + this.A[n].vLen), 6);
            panel.add(textField);
            panel.add(new Label(", end: "));
            panel.add(textField2);
            dialog.pack();
            button.addActionListener(iDlgCL);
            button2.addActionListener(iDlgCL);
            dialog.setVisible(true);
            if (!this.cancel) {
                double d = Tools.parseDouble(textField.getText());
                double d2 = Tools.parseDouble(textField2.getText());
                this.A[n].setValueRange(d, d2 - d);
                this.setUpdateRoot(0);
                this.repaint();
            }
            dialog.dispose();
        }
        if (string == "exportCases") {
            try {
                PrintStream printStream = Tools.getNewOutputStreamDlg(this.myFrame, "Export selected cases to ...", "selected.txt");
                if (printStream != null) {
                    printStream.println(this.v[0].getName() + "\t" + this.v[1].getName());
                    int n = this.v[0].size();
                    for (int i = 0; i < n; ++i) {
                        if (!this.m.at(i)) continue;
                        object2 = this.v[0].at(i);
                        printStream.println((object2 == null ? "NA" : object2.toString()) + "\t" + (this.v[1].at(i) == null ? "NA" : this.v[1].at(i).toString()));
                    }
                    printStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        this.run(actionEvent.getSource(), actionEvent.getActionCommand());
    }
}

