% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devtools.R
\name{roxy_tag_rd.roxy_tag_iparam}
\alias{roxy_tag_rd.roxy_tag_iparam}
\title{Support for \verb{@iparam} tags}
\usage{
\method{roxy_tag_rd}{roxy_tag_iparam}(x, base_path, env)
}
\arguments{
\item{x}{The tag}

\item{base_path}{Path to package root directory.}

\item{env}{Environment in which to evaluate code (if needed)}
}
\value{
an \code{roxygen2::rd_section} (see \code{roxygen2} documentation)
}
\description{
The \verb{@iparam <name> <description>} tag can be used in \code{roxygen2} documentation
of a function to describe a dataframe parameter. The function must be using
\code{interfacer::iface} to define the input dataframe parameter format. The
\verb{@iparam} tag will then generate documentation about the type of dataframe
the function is expecting.
}
\examples{

# An example function definition:
fn_definition <- "
#' This is a title
#'
#' This is the description.
#'
#' @md
#' @iparam df the input
#' @export
f <- function(df = interfacer::iface(
  id = integer ~ \"an integer `ID`\",
  test = logical ~ \"the test result\"
)) {
  ivalidate(df)
}
"

# For this example we manually parse the function specification in `fn_definition`
# creating a .Rd block - normally this is done by `roxygen2` which then
# writes this to an .Rd file. This function is not intended to be used
# outside of a call to `devtools::document`.

tmp = roxygen2::parse_text(fn_definition)
print(tmp)

}
\concept{document}
