% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obtainRichness.R
\name{obtainRichness}
\alias{obtainRichness}
\title{\code{obtainRichness}: Function to obtain richness estimates from a \code{\link[PointedSDMs]{fitISDM}} object.}
\usage{
obtainRichness(
  modelObject,
  predictionData,
  predictionIntercept,
  sampleSize = 1,
  inclProb = TRUE
)
}
\arguments{
\item{modelObject}{A \code{\link[PointedSDMs]{fitISDM}} object of class \code{modSpecies}.}

\item{predictionData}{An \code{sf} data.frame object of containing the locations and covariates that are predicted on.}

\item{predictionIntercept}{The name of the prediction dataset to use in the model.}

\item{sampleSize}{The size of the sampling area for the prediction intercept dataset. Defaults to \code{1}.}

\item{inclProb}{Include the individual probabilities for each species. Defaults to \code{TRUE}}
}
\value{
An \code{sf} data.frame object of richness at each sampling location.
}
\description{
This function is used to obtain richness estimates for a multi-species ISDM.
}
