% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bm_shift}
\alias{bm_shift}
\alias{bru_mapper_shift}
\alias{ibm_n.bm_shift}
\alias{ibm_n_output.bm_shift}
\alias{ibm_values.bm_shift}
\alias{ibm_jacobian.bm_shift}
\alias{ibm_eval.bm_shift}
\title{Mapper for element-wise shifting}
\usage{
bm_shift(mapper = NULL)

bru_mapper_shift(...)

\method{ibm_n}{bm_shift}(mapper, ..., state = NULL, n_state = NULL)

\method{ibm_n_output}{bm_shift}(mapper, input, state = NULL, ..., n_state = NULL)

\method{ibm_values}{bm_shift}(mapper, ..., state = NULL, n_state = NULL)

\method{ibm_jacobian}{bm_shift}(mapper, input, state = NULL, ..., sub_lin = NULL)

\method{ibm_eval}{bm_shift}(mapper, input, state = NULL, ..., sub_lin = NULL)
}
\arguments{
\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{...}{Arguments passed on to other methods}

\item{state}{A vector of latent state values for the mapping,
of length \code{ibm_n(mapper, inla_f = FALSE)}}

\item{n_state}{integer giving the length of the state vector for mappers
that have state dependent output size.}

\item{input}{Data input for the mapper.}

\item{sub_lin}{Internal, optional pre-computed sub-mapper information}
}
\description{
Create a standalone
shift mapper that can be used as part of a \code{bm_pipe}.
If \code{mapper} is non-null, the \code{bm_shift()} constructor
returns
\code{bm_pipe(list(mapper = mapper, shift = bm_shift()))}
}
\section{Methods (by generic)}{
\itemize{
\item \code{ibm_jacobian(bm_shift)}: \code{input} NULL values are interpreted as no shift.

}}
\examples{
m <- bm_shift()
ibm_eval2(m, c(1, 2, 1, 2), 1:4)

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bm_aggregate}()},
\code{\link{bm_collect}()},
\code{\link{bm_const}()},
\code{\link{bm_factor}()},
\code{\link{bm_fmesher}()},
\code{\link{bm_harmonics}()},
\code{\link{bm_index}()},
\code{\link{bm_linear}()},
\code{\link{bm_logsumexp}()},
\code{\link{bm_marginal}()},
\code{\link{bm_matrix}()},
\code{\link{bm_mesh_B}()},
\code{\link{bm_multi}()},
\code{\link{bm_pipe}()},
\code{\link{bm_repeat}()},
\code{\link{bm_scale}()},
\code{\link{bm_sum}()},
\code{\link{bm_taylor}()},
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_generics}}
}
\concept{mappers}
