% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bm_fmesher}
\alias{bm_fmesher}
\alias{bru_mapper_fmesher}
\alias{ibm_n.bm_fmesher}
\alias{ibm_values.bm_fmesher}
\alias{ibm_jacobian.bm_fmesher}
\title{Mapper for general \code{fmesher} function space objects}
\usage{
bm_fmesher(mesh)

bru_mapper_fmesher(...)

\method{ibm_n}{bm_fmesher}(mapper, ...)

\method{ibm_values}{bm_fmesher}(mapper, ...)

\method{ibm_jacobian}{bm_fmesher}(mapper, input, ...)
}
\arguments{
\item{mesh}{An \code{fmesher} object to map, supported by
\link[fmesher:fm_basis]{fmesher::fm_basis}\verb{(mesh, input)} and
\link[fmesher:fm_dof]{fmesher::fm_dof}\code{(mesh)}.}

\item{...}{Arguments passed on to other methods}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{input}{Data input for the mapper.}
}
\value{
A \code{bm_fmesher} object.
}
\description{
Creates a mapper for general \code{fmesher} function space objects.
}
\details{
Handles indexed mapping for all \code{fmesher} classes that support
\code{fm_dof()} and \code{fm_basis()} methods. For non-indexed mapping of
\code{fm_mesh_1d} objects, use \code{bru_mapper(mesh, indexed = FALSE)} which
invokes the \code{\link[=bru_mapper.fm_mesh_1d]{bru_mapper.fm_mesh_1d()}} method.
}
\examples{
m <- bm_fmesher(fmesher::fmexample$mesh)
ibm_n(m)
ibm_eval(m, as.matrix(expand.grid(-2:2, -2:2)), seq_len(ibm_n(m)))

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bm_aggregate}()},
\code{\link{bm_collect}()},
\code{\link{bm_const}()},
\code{\link{bm_factor}()},
\code{\link{bm_harmonics}()},
\code{\link{bm_index}()},
\code{\link{bm_linear}()},
\code{\link{bm_logsumexp}()},
\code{\link{bm_marginal}()},
\code{\link{bm_matrix}()},
\code{\link{bm_mesh_B}()},
\code{\link{bm_multi}()},
\code{\link{bm_pipe}()},
\code{\link{bm_repeat}()},
\code{\link{bm_scale}()},
\code{\link{bm_shift}()},
\code{\link{bm_sum}()},
\code{\link{bm_taylor}()},
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_generics}}
}
\concept{mappers}
