% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bm_linear}
\alias{bm_linear}
\alias{bru_mapper_linear}
\alias{ibm_n.bm_linear}
\alias{ibm_values.bm_linear}
\alias{ibm_jacobian.bm_linear}
\title{Mapper for a linear effect}
\usage{
bm_linear()

bru_mapper_linear()

\method{ibm_n}{bm_linear}(mapper, ...)

\method{ibm_values}{bm_linear}(mapper, ...)

\method{ibm_jacobian}{bm_linear}(mapper, input, ...)
}
\arguments{
\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{...}{Arguments passed on to other methods}

\item{input}{Data input for the mapper.}
}
\description{
Create a mapper for linear effects
}
\examples{
m <- bm_linear()
ibm_eval(m, input = 1:4, state = 2)

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bm_aggregate}()},
\code{\link{bm_collect}()},
\code{\link{bm_const}()},
\code{\link{bm_factor}()},
\code{\link{bm_fmesher}()},
\code{\link{bm_harmonics}()},
\code{\link{bm_index}()},
\code{\link{bm_logsumexp}()},
\code{\link{bm_marginal}()},
\code{\link{bm_matrix}()},
\code{\link{bm_mesh_B}()},
\code{\link{bm_multi}()},
\code{\link{bm_pipe}()},
\code{\link{bm_repeat}()},
\code{\link{bm_scale}()},
\code{\link{bm_shift}()},
\code{\link{bm_sum}()},
\code{\link{bm_taylor}()},
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_generics}}
}
\concept{mappers}
