% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{streptomycin_tbl_df}
\alias{streptomycin_tbl_df}
\title{Tuberculosis Streptomycin RCT (1948)}
\format{
A tibble with 107 observations and 13 variables:
\describe{
  \item{patient_id}{Character identifier for each patient}
  \item{arm}{Factor indicating treatment arm: streptomycin (A2) or placebo (A1)}
  \item{dose_strep_g}{Numeric dose of streptomycin in grams}
  \item{dose_PAS_g}{Numeric dose of para-aminosalicylic acid (PAS) in grams}
  \item{gender}{Factor with two levels indicating patient gender}
  \item{baseline_condition}{Factor indicating the baseline clinical condition of the patient}
  \item{baseline_temp}{Factor indicating baseline temperature category}
  \item{baseline_esr}{Factor indicating baseline erythrocyte sedimentation rate (ESR) category}
  \item{baseline_cavitation}{Factor indicating the presence or absence of lung cavitation at baseline}
  \item{strep_resistance}{Factor indicating the level of resistance to streptomycin}
  \item{radiologic_6m}{Factor describing radiological outcomes at 6 months}
  \item{rad_num}{Numeric radiologic score at 6 months}
  \item{improved}{Logical indicator of clinical improvement}
}
}
\source{
Data taken from the medicaldata package version 0.2.0
}
\usage{
data(streptomycin_tbl_df)
}
\description{
This dataset, streptomycin_tbl_df, is a tibble containing the results of a randomized,
placebo-controlled, prospective 2-arm trial evaluating the use of streptomycin
(2 grams daily) versus placebo in the treatment of tuberculosis among 107 young patients.
The study was conducted by the Streptomycin in Tuberculosis Trials Committee and
published in the British Medical Journal in 1948.
}
\details{
The dataset name has been kept as 'streptomycin_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
infectiousR package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble (a modern form of data frame).
The original content has not been modified in any way.
}
