% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendogram.R
\name{add_row_dendro}
\alias{add_row_dendro}
\alias{add_row_dendro,Iheatmap,hclust-method}
\title{add_row_dendro}
\usage{
\S4method{add_row_dendro}{Iheatmap,hclust}(
  p,
  dendro,
  reorder = TRUE,
  side = c("left", "right"),
  size = 0.15,
  buffer = 0.005,
  xname = NULL,
  yname = current_yaxis(p),
  sname = "row_dendro"
)
}
\arguments{
\item{p}{iheatmap object}

\item{dendro}{hclust object}

\item{reorder}{reorder rows based on dendrogram order?}

\item{side}{side of plot on which to add dendrogram}

\item{size}{relative size of dendrogram (relative to the main heatmap)}

\item{buffer}{amount of space to leave empty before this plot, relative to 
size of first heatmap}

\item{xname}{internal  name of xaxis}

\item{yname}{internal name of yaxis}

\item{sname}{internal name of shapes}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
Adds row dendrogram to iheatmap object
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)  
dend <- hclust(dist(mat))
hm <- iheatmap(mat) \%>\% add_row_dendro(dend)

# Print heatmap if interactive session 
if (interactive()) hm 
}
\seealso{
\code{\link{add_row_clustering}}, \code{\link{iheatmap}}, 
\code{\link{add_col_dendro}}
}
\author{
Alicia Schep
}
