% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_ieegio_space.R
\name{new_space}
\alias{new_space}
\title{Define a coordinate space}
\usage{
new_space(name = "", orientation = ORIENTATION_CODES, dimension = 3, ...)
}
\arguments{
\item{name}{character string identifying the coordinate space (e.g.,
\code{"T1w"}, \code{"MNI152NLin2009cAsym"}, \code{"scanner"});
default is \code{""}, a wildcard that indicates arbitrary space}

\item{orientation}{character string specifying the axis orientation
convention. Common orientations in brain imaging:
\itemize{
\item \code{"RAS"}: Right-Anterior-Superior (FreeSurfer, NIfTI default)
\item \code{"LAS"}: Left-Anterior-Superior
\item \code{"LPS"}: Left-Posterior-Superior (\code{DICOM}, \code{ANTs}, \code{ITK})
\item \code{"RPS"}: Right-Posterior-Superior
\item \code{"LPI"}: Left-Posterior-Inferior
\item \code{"RPI"}: Right-Posterior-Inferior
\item \code{"LAI"}: Left-Anterior-Inferior
\item \code{"RAI"}: Right-Anterior-Inferior
}}

\item{dimension}{integer dimension of the space (typically 3 for 3D imaging)}

\item{...}{additional attributes to attach to the space object}
}
\value{
An S3 object of class \code{"ieegio_space"} with attributes
\code{orientation} and \code{dimension}
}
\description{
Creates an object representing a coordinate space/reference frame used in
medical imaging. The orientation defines the anatomical meaning of the
coordinate axes.
}
\details{
Orientation codes use three letters to define the positive direction of the
x, y, and z axes respectively:
\itemize{
\item First letter (x-axis): \strong{L}eft or \strong{R}ight
\item Second letter (y-axis): \strong{A}nterior or \strong{P}osterior
\item Third letter (z-axis): \strong{S}uperior or \strong{I}nferior
}

For example, \code{"RAS"} means: +x points Right, +y points Anterior
(toward face), +z points Superior (toward top of head).
}
\examples{
# FreeSurfer/NIfTI convention
scanner_space <- new_space("scanner", orientation = "RAS")
print(scanner_space)

# DICOM/ANTs convention
mni_space <- new_space("MNI152NLin2009cAsym", orientation = "LPS", dimension = 3)
format(mni_space)

}
