% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_functions.R
\name{initial_values}
\alias{initial_values}
\title{Initial Values for Estimation under Log-concavity with Interval-Censored Data}
\usage{
initial_values(X, initial = "LCM")
}
\arguments{
\item{X}{A matrix or data frame of interval-censored data, where each row contains the lower and upper bounds of the interval for each observation.}

\item{initial}{A character string specifying the method for generating initial values. 
The default is \code{"LCM"}, which uses the least concave majorant of the log of the unconstrained MLE. 
Other options are \code{"MLE"} for the unconstrained maximum likelihood estimate 
or a numeric vector provided by the user.}
}
\value{
A list containing:
\describe{
  \item{phi_hat}{The initial values of the \code{phi} parameter based on the specified method.}
  \item{phi_hat_MLE}{Initial values based on the unconstrained MLE.}
  \item{phi_hat_LCM}{Initial values based on the least concave majorant.}
}
}
\description{
This function obtains initial values for the maximum likelihood estimation under log-concavity with 
interval-censored data based on the unconstrained maximum likelihood estimate (MLE) 
or its least concave majorant (LCM). 
Alternatively, the user can provide a numeric vector of initial values.
}
