% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mohn.R
\name{mohn}
\alias{mohn}
\title{Mohn's Rho}
\usage{
mohn(x, peels = 5, details = FALSE, plot = FALSE, ...)
}
\arguments{
\item{x}{a matrix or data frame containing retrospective estimates in
columns, with years as row names.}

\item{peels}{the number of retrospective peels to use in the calculation of
rho, or \code{NULL} to use all retrospective columns in \code{x}.}

\item{details}{whether to return the intermediate calculations of relative
bias.}

\item{plot}{whether to plot the retrospective trajectories.}

\item{\dots}{passed to \code{matplot} and \code{points}.}
}
\value{
Mohn's rho, along with intermediate calculations if \code{details = TRUE}.
}
\description{
Calculate Mohn's rho, the average relative bias of retrospective estimates.
}
\details{
The default value \code{peels = 5} is based on the ICES (2018) guidelines.

The basic \code{plot = TRUE} functionality is intended to quickly visualize
the calculation of Mohn's rho. To produce a fully formatted plot, bypass the
\code{mohn} function and plot the \code{x} data directly.
}
\note{
Relative bias is defined as
\deqn{b_i=\frac{\hat\theta^{R_i}_{T\!-i}\,-\,\hat\theta_{T\!-i}}{\hat\theta_{T\!-i}}}{relbias
= (retro - base) / base}
and Mohn's rho is the average relative bias:
\deqn{\rho=\sum_{i=1}^n\frac{b_i}{n}}{rho = mean(relbias)}

See Mohn (1999), Brooks and Legault (2016), ICES (2018), and
\code{mohn(shake, details=TRUE)} for details.
}
\examples{
mohn(shake)
mohn(shake, details=TRUE)
mohn(shake, plot=TRUE)

mohn(shake, peels=3, plot=TRUE, col="black", ylim=0:1, yaxs="i")
lines(as.numeric(rownames(shake)), shake$base, lwd=3)

## Plot last 10 years
x <- rbind(matrix(1,28,6,dimnames=list(1981:2008,names(shake))), shake)
mohn(tail(x, 10), plot=TRUE, lwd=2, main="main")

}
\references{
Brooks, E. N. and Legault, C. M. (2016) Retrospective forecasting ---
evaluating performance of stock projections in New England groundfish stocks.
\emph{Canadian Journal of Fisheries and Aquatic Sciences}, \bold{73},
935--950.

ICES (2018) Guidelines for calculating Mohn's rho: Retrospective bias in
assessment. \emph{Draft document version 7 (2018-04-03), available at the
Expert Groups area on the ICES Sharepoint.}

ICES (2020) Workshop on Catch Forecast from Biased Assessments (WKFORBIAS;
outputs from 2019 meeting).
\doi{10.17895/ices.pub.5997}{\emph{ICES Scientific Reports
2(28)}}.

Mohn, R. (1999) The retrospective problem in sequential population analysis:
An investigation using cod fishery and simulated data. \emph{ICES Journal of
Marine Science}, \bold{56}, 473--488.
}
\seealso{
\code{\link{shake}} is a retrospective example table.

\code{\link{icesAdvice-package}} gives an overview of the package.
}
\author{
Arni Magnusson, with a contribution from Ruben Verkempynck.
}
