% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/total_ibd_dist_moments.R
\name{total_ibd_dist_moments}
\alias{total_ibd_dist_moments}
\title{Compute moments of probability distribution of total IBD}
\usage{
total_ibd_dist_moments(
  pedigree,
  ids = pedtools::leaves(pedigree),
  fraction = FALSE,
  states = "ibd",
  ibd_state = 1L,
  chromosome_length = 267.77
)
}
\arguments{
\item{pedigree}{Pedigree in \code{\link[pedtools:ped]{pedtools::ped}} form.}

\item{ids}{Ids for which IBD is observed. Default is \code{pedtools::leaves(pedigree)}.}

\item{fraction}{If TRUE, the distribution of the IBD fraction instead of length will be returned. Default is FALSE.}

\item{states}{One of \code{"ibd"} (default), \code{"kappa"}, \code{"identity"} or \code{"detailed"}.}

\item{ibd_state}{Default is 1.}

\item{chromosome_length}{Default is 267.77 cM (an estimate of the length of chromosome 1).}
}
\value{
\code{list}
}
\description{
The \code{total_ibd_dist_moments} function computes mean and variance of
the probability distribution of the total IBD length (or fraction)
over one autosome. The function uses double numerical integration.
}
\examples{
# Full Siblings are double IBD with 25\% probability
# we may compute the expectation and variance of the total length of
# a chromosome that is double IBD for a chromosome of 100 cM (i.e. 1 Morgan)
m <- total_ibd_dist_moments(pedigree = pedtools::nuclearPed(nch = 2),
                       ibd_state = 2, chromosome_length = 100)
m

# compare to numerical integration of the full distribution
d_fs <- total_ibd_dist(pedigree = pedtools::nuclearPed(nch = 2),
ibd_state = 2, chromosome_length = 100)

m2 <- list(mean = E(d_fs), variance = var(d_fs), sd = sd(d_fs))
m2

stopifnot(all.equal(m, m2))

# Expectation and variance of _fraction_ of the genome that is
# double IBD between four full siblings
m4 <- total_ibd_dist_moments(pedigree = pedtools::nuclearPed(nch = 4),
ibd_state = 2, chromosome_length = 100, fraction = TRUE)
m4

stopifnot(all.equal(0.25^3, m4$mean))
}
