% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaibase.R
\name{roc_curve.classification_multi_learner}
\alias{roc_curve.classification_multi_learner}
\title{Construct an ROC curve using a trained multi-task classification learner on
the given data}
\usage{
\method{roc_curve}{classification_multi_learner}(obj, X, y, ...)
}
\arguments{
\item{obj}{The learner or grid to use for prediction.}

\item{X}{The features of the data.}

\item{y}{The labels of the data.}

\item{...}{Refer to the Julia documentation for available parameters.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.2.2/IAIBase/reference/#IAI.ROCCurve-Tuple\%7BLearner\%7BIAIBase.MultiTask\%7BIAIBase.ClassificationTask\%7D\%7D\%2C\%20Union\%7BDataFrames.AbstractDataFrame\%2C\%20AbstractMatrix\%7B\%3C\%3AReal\%7D\%7D\%2C\%20Union\%7BDataFrames.AbstractDataFrame\%2C\%20AbstractMatrix\%7D\%7D}{\code{IAI.ROCCurve}}
and
\href{https://docs.interpretable.ai/v3.2.2/IAIBase/reference/#IAI.ROCCurve-Tuple\%7BLearner\%7BIAIBase.MultiTask\%7BIAIBase.ClassificationTask\%7D\%7D\%2C\%20Union\%7BDataFrames.AbstractDataFrame\%2C\%20AbstractMatrix\%7B\%3C\%3AReal\%7D\%7D\%2C\%20Union\%7BDataFrames.AbstractDataFrame\%2C\%20AbstractMatrix\%7D\%2C\%20Symbol\%7D}{\code{IAI.ROCCurve}}
}
\section{IAI Compatibility}{

Requires IAI version 3.2 or higher.
}

\examples{
\dontrun{iai::roc_curve(lnr, X, y)}

}
