% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ispca.plot.R
\name{ispca.plot}
\alias{ispca.plot}
\title{Plot the results of ispca}
\usage{
ispca.plot(x, type)
}
\arguments{
\item{x}{list of "ispca", which is the result of command "ispca".}

\item{type}{character, "path" or "loading" type, if "path", plot the the convergence path graph of the first eigenvector u in the integrative sparse principal component analysis method, if "loading", plot the first eigenvector.}
}
\value{
the convergence path graph or the scatter diagrams of the first eigenvector u.
}
\description{
Plot the convergence path graph or estimated value of the first eigenvector u in the integrative sparse principal component analysis method.
}
\details{
See details in \code{\link{ispca}}.
}
\examples{
library(iSFun)
data("simData.pca")
x <- simData.pca$x
L <- length(x)

res_homo_m <- ispca(x = x, L = L, mu1 = 0.5, mu2 = 0.002, trace = FALSE, draw = FALSE)
ispca.plot(x = res_homo_m, type = "path")
ispca.plot(x = res_homo_m, type = "loading")
}
