#' Auxiliary Internal Functions
#'
#' @rdname n_elecfuns
#' @param v vector of vote totals by party 
#' @param s vector with the seats received by each party.
#'
#' @usage lsq(v, s) 
#'
#' @return The "least squares" index of disproportionality
#'
lsq <- function(v, s){
  Vp <- v/sum(v)
  Sp <- s/sum(s)
  lsq <- sqrt(1/2 * sum((Vp - Sp)^2)) * 100
  return(lsq)
}