% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_qm_vol.R
\name{qm_vol}
\alias{qm_vol}
\title{Monthly river discharge [m3/s] to volume [hm3]}
\usage{
qm_vol(x, col_name, out_name = NULL)
}
\arguments{
\item{x}{data frame with class Date in the first column and
numeric on the others.}

\item{col_name}{string with column(s) name(s) where to apply the function.}

\item{out_name}{optional. String with new column(s) name(s). If you set it as \code{NULL},
the function will overwrite the original data frame.}
}
\value{
The same data frame but with the total volume discharge.
}
\description{
Converts mean monthly river discharge [m3/s] to total volume discharge [hm3].
}
\examples{

# read guido daily streamflow records
path <- system.file('extdata', 'snih_qd_guido.xlsx',
        package = 'hydrotoolbox')

# read, aggregate the function to monthly resolution and get the volume
qm_guido <-
  read_snih(path = path, by = 'day', out_name = 'q(m3/s)') \%>\%
  agg_table(col_name = 'q(m3/s)', fun = 'mean', period = 'monthly',
            out_name = 'qm(m3/s)') \%>\%
  qm_vol(col_name = 'qm(m3/s)', out_name = 'vm(hm3)')


}
