% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_miss_data.R
\name{report_miss_data}
\alias{report_miss_data}
\title{Report \code{NA_real_} values}
\usage{
report_miss_data(df, Lang = "spanish")
}
\arguments{
\item{df}{data frame with hydro-meteo data. First column is date and the second the numeric vector to be reported.}

\item{Lang}{string with output column name language: 'spanish' (default) or 'english'.}
}
\value{
A data frame with three columns: start-date, end-date and number of missing time steps.
}
\description{
Creates a data frame with reported dates and number of times-step of missing or not recorded data.
}
\examples{
# Create BDHI hydro-met station
guido <- create_hydroMet(class_name = 'BDHI')

# List with meteorological variables (slots in BDHI's object)
cargar <- list('precip', 'Qmd', 'Qmm')

# Now assign as names the files
hydro_files   <- list.files( system.file('extdata', package = "hydroToolkit"), pattern = 'Guido' )
names(cargar) <- hydro_files

# Build the object with the met records
guido <- build_hydroMet(obj = guido, slot_list = cargar, 
               path = system.file('extdata', package = "hydroToolkit") )
               
# Get mean daily discharge and report miss data
Qmd  <- get_hydroMet(obj = guido, name = 'Qmd')[[1]]
miss <- report_miss_data(df = Qmd)
 
}
