% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_CR2.R
\name{read_CR2}
\alias{read_CR2}
\title{Reads data from Explorador Climático de Chile}
\usage{
read_CR2(file, colName, path = NULL)
}
\arguments{
\item{file}{string with the file name (include extension). The only accepted format is '.csv'.}

\item{colName}{string with the name of the variable.}

\item{path}{string with the files directory. If not provided, the function will use the current working directory.}
}
\value{
A two column data frame with date and variable. Gaps between dates are filled with \code{NA_real_} and duplicated rows are eliminated automatically.
}
\description{
Reads data downloaded from Explorador Climatico de Chile (\href{http://explorador.cr2.cl/}{CR2}) as a data frame.
}
\examples{
# Relative path to raw data
full_path <- system.file('extdata', package = "hydroToolkit")

# Apply function
yeso_tmed <- read_CR2(file = 'Tmed_Yeso_Embalse.csv', 
                colName = 'T(ºC)', path = full_path)


}
