% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_plot_hydroMet.R
\name{plot_hydroMet}
\alias{plot_hydroMet}
\alias{plot_hydroMet,hydroMet_BDHI-method}
\alias{plot_hydroMet,hydroMet_CR2-method}
\alias{plot_hydroMet,hydroMet_DGI-method}
\alias{plot_hydroMet,hydroMet_IANIGLA-method}
\alias{plot_hydroMet,hydroMet_compact-method}
\title{Methods to easily use \code{ggplot2} or \code{plotly} (interactive)}
\usage{
plot_hydroMet(
  obj,
  slot_name,
  col_number,
  interactive = FALSE,
  line_type = NULL,
  line_color = "dodgerblue",
  x_lab = "Date",
  y_lab = "y",
  title_lab = NULL,
  legend_lab = NULL,
  double_yaxis = NULL,
  list_extra = NULL,
  from = NULL,
  to = NULL,
  scatter = NULL
)

\S4method{plot_hydroMet}{hydroMet_BDHI}(
  obj,
  slot_name,
  col_number,
  interactive = FALSE,
  line_type = NULL,
  line_color = "dodgerblue",
  x_lab = "Date",
  y_lab = "y",
  title_lab = NULL,
  legend_lab = NULL,
  double_yaxis = NULL,
  list_extra = NULL,
  from = NULL,
  to = NULL
)

\S4method{plot_hydroMet}{hydroMet_CR2}(
  obj,
  slot_name,
  col_number,
  interactive = FALSE,
  line_type = NULL,
  line_color = "dodgerblue",
  x_lab = "Date",
  y_lab = "y",
  title_lab = NULL,
  legend_lab = NULL,
  double_yaxis = NULL,
  list_extra = NULL,
  from = NULL,
  to = NULL
)

\S4method{plot_hydroMet}{hydroMet_DGI}(
  obj,
  slot_name,
  col_number,
  interactive = FALSE,
  line_type = NULL,
  line_color = "dodgerblue",
  x_lab = "Date",
  y_lab = "y",
  title_lab = NULL,
  legend_lab = NULL,
  double_yaxis = NULL,
  list_extra = NULL,
  from = NULL,
  to = NULL
)

\S4method{plot_hydroMet}{hydroMet_IANIGLA}(
  obj,
  slot_name,
  col_number,
  interactive = FALSE,
  line_type = NULL,
  line_color = "dodgerblue",
  x_lab = "Date",
  y_lab = "y",
  title_lab = NULL,
  legend_lab = NULL,
  double_yaxis = NULL,
  list_extra = NULL,
  from = NULL,
  to = NULL
)

\S4method{plot_hydroMet}{hydroMet_compact}(
  obj,
  slot_name,
  col_number,
  interactive = FALSE,
  line_type = NULL,
  line_color = "dodgerblue",
  x_lab = "x",
  y_lab = "y",
  title_lab = NULL,
  legend_lab = NULL,
  double_yaxis = NULL,
  list_extra = NULL,
  from = NULL,
  to = NULL,
  scatter = NULL
)
}
\arguments{
\item{obj}{a valid \code{hydroMet_XXX} object.}

\item{slot_name}{string(s) with the name of the slot(s) to use in plotting.}

\item{col_number}{numeric (vector) with the column's variable to plot. In case you decide to merge slots you must provide a list in which each element contains the column numbers of the variable to plot.}

\item{interactive}{logical. Default value, \code{FALSE}, will return a \code{ggplot2} class object. Otherwise you will get a \code{plotly} one.}

\item{line_type}{string  with line dash type (\code{ggplot2}) or mode in \code{plotly} case. \code{ggplot2}: \code{'solid'} (default value), \code{'twodash'}, \code{'longdash'}, \code{'dotted'}, \code{'dotdash'}, \code{'dashed'} or \code{'blank'}. \code{plotly}: \code{'lines'} (default value), \code{'lines+markers'} or \code{'markers'}.}

\item{line_color}{string with a valid \code{color}. See 'colors()' or \href{http://www.stat.columbia.edu/~tzheng/files/Rcolor.pdf}{Rcolor document}.}

\item{x_lab}{string with \code{x axis} label.}

\item{y_lab}{string with \code{y axis} label. In case you use \code{double_yaxis} argument you must supply both \code{c('ylab', 'y2lab')}.}

\item{title_lab}{string with the title of the plot. Default is a plot without title.}

\item{legend_lab}{string with plot label(s) name(s). \bold{NOTE}: \code{ggplot2} double_yaxis does not support \code{legend_lab} in this package version, so giving values to this argument will be harmfulness.}

\item{double_yaxis}{numeric vector with either \code{1} (= main axis - left) or \code{2} (= secondary axis - right) indicating whether the variable should be plotted in either left or right axis. \bold{NOTE}: in this package version \code{ggplot2} supports just one line plot for each 'y' axis.}

\item{list_extra}{list with the \code{ggplot2} argument to pass. This argument was design to allow the user to modify \code{ggplot2} arguments (you can find nice examples in \href{http://www.sthda.com/english/wiki/ggplot2-title-main-axis-and-legend-titles}{ggplot2 - Essentials}) \bold{NOTE}: in this package version this argument doesn't make sense for \code{plotly} (except for \code{scatter} plot in \code{hydroMet_compact} class).}

\item{from}{string (or \code{POSIXct} - valid only in 'BDHI' and  'IANIGLA') with the starting \code{Date}. You can use \code{'from'} without \code{'to'}. In this case you will subset your data 'from' till the end.}

\item{to}{string (or \code{POSIXct} - valid only in 'BDHI' and  'IANIGLA') with the ending \code{Date}. You can use \code{'to'} without \code{'from'}. In this case you will subset your data from the beginning till 'to'.}

\item{scatter}{numeric vector of length two with the column number to plot as scatter. The first variable (column number) will be the \code{'x'} variable and the second one the \code{'y'} variable. This argument will work just for class \code{hydroMet_compact}.}
}
\value{
A \code{ggplot2} or \code{plotly} objects to analyze your data.
}
\description{
This method allows you to make plots (using simple and expressive arguments) of the variables contained inside an \code{hydroMet_XXX} object. The plot outputs can be static (\code{ggplot2}) or interactive (\code{plotly}).
}
\section{Functions}{
\itemize{
\item \code{plot_hydroMet,hydroMet_BDHI-method}: plot method for BDHI class

\item \code{plot_hydroMet,hydroMet_CR2-method}: plot method for CR2 class

\item \code{plot_hydroMet,hydroMet_DGI-method}: plot method for DGI class

\item \code{plot_hydroMet,hydroMet_IANIGLA-method}: plot method for IANIGLA class

\item \code{plot_hydroMet,hydroMet_compact-method}: plot method for \code{compact} class
}}

\examples{
# Path to file
dgi_path  <- system.file('extdata', package = "hydroToolkit")
file_name <- list.files(path = dgi_path, pattern = 'Toscas')

# Read Toscas
var_nom <- list(slotNames(x = 'hydroMet_DGI')[2:7])
names(var_nom) <- file_name

# Load Toscas meteo station data
toscas_dgi <- create_hydroMet(class_name = 'DGI')
toscas_dgi <- build_hydroMet(obj = toscas_dgi, slot_list = var_nom, path = dgi_path)

# Plot mean air temperature
plot_hydroMet(obj = toscas_dgi, col_number = 2, slot_name = 'tmean',
 legend_lab = 'Tmean(ºC)' )

# Now let's plot an interactive graph
plot_hydroMet(obj = toscas_dgi, col_number = 2, slot_name = 'tmean',
 interactive = TRUE, y_lab = 'Tmean(ºC)' ) 

}
