% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precip_cumsum.R
\name{precip_cumsum}
\alias{precip_cumsum}
\title{Cumulative sum of precipitation series}
\usage{
precip_cumsum(df, col_number = 2, out_name = NULL)
}
\arguments{
\item{df}{data frame with \code{Date} (or \code{POSIXct}) in the first column and \code{numeric} variables on the others.}

\item{col_number}{numeric. The column number of the series where to apply the cumulative sum.}

\item{out_name}{optional. String value with the column output name. Default is 'cumsum_' plus the original name.}
}
\value{
A data frame with two columns: date and the cumulative sum of the series.
}
\description{
Returns a data frame with two columns: the date and the cumulative sum of the chosen \code{col_number}. This function can deal with \code{NA_real_}.
}
\examples{
# Load daily precipitation data-set from BDHI
load( paste0(system.file('extdata', package = "hydroToolkit"), '/bdhi_p.rda') )

# Get compact slot
p_bdhi <- get_hydroMet(obj = bdhi_p, name = 'compact')[[1]]

# Apply cumulative precipitation function
p_cum <- precip_cumsum(df = p_bdhi, col_number = 2, out_name = 'cum_guido')

}
