% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_scales.R
\name{hues-ggplot2-scales}
\alias{hues-ggplot2-scales}
\alias{scale_colour_iwanthue}
\alias{scale_color_iwanthue}
\alias{scale_fill_iwanthue}
\title{iwanthue scales to use with ggplot2}
\usage{
scale_colour_iwanthue(
  ...,
  hmin = 0,
  hmax = 360,
  cmin = 0,
  cmax = 180,
  lmin = 0,
  lmax = 100,
  random = FALSE,
  aesthetics = "colour"
)

scale_color_iwanthue(
  ...,
  hmin = 0,
  hmax = 360,
  cmin = 0,
  cmax = 180,
  lmin = 0,
  lmax = 100,
  random = FALSE,
  aesthetics = "colour"
)

scale_fill_iwanthue(
  ...,
  hmin = 0,
  hmax = 360,
  cmin = 0,
  cmax = 180,
  lmin = 0,
  lmax = 100,
  random = FALSE,
  aesthetics = "fill"
)
}
\arguments{
\item{...}{Arguments to pass on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}

\item{hmin}{Numeric, in the range \verb{[0, 360]}. The lower limit of the hue
range to be clustered.}

\item{hmax}{Numeric, in the range \verb{[0, 360]}. The upper limit of the hue
range to be clustered.}

\item{cmin}{Numeric, in the range \verb{[0, 180]}. The lower limit of the chroma
range to be clustered.}

\item{cmax}{Numeric, in the range \verb{[0, 180]}. The upper limit of the chroma
range to be clustered.}

\item{lmin}{Numeric, in the range \verb{[0, 100]}. The lower limit of the
luminance range to be clustered.}

\item{lmax}{Numeric, in the range \verb{[0, 100]}. The upper limit of the
luminance range to be clustered.}

\item{random}{Logical. If \code{TRUE}, clustering will be determined by the
existing RNG state. If \code{FALSE}, the seed will be set to \code{1} for clustering,
and on exit, the function will restore the pre-existing RNG state.}

\item{aesthetics}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful,
for example, to apply colour settings to the colour and fill aesthetics at
the same time, via \code{aesthetics = c("colour", "fill")}.}
}
\value{
A \code{ScaleDiscrete} object that can be added to a \code{ggplot} object.
}
\description{
These functions allow you to use \code{\link[=iwanthue]{iwanthue()}} generated palettes with
\code{ggplot2} plots. You need \code{ggplot2} installed for these to work. Note these
only work with discrete scales.
}
\examples{

if (require('ggplot2')) {

   ggplot(iris, aes(x=Petal.Width, y=Petal.Length)) +
     geom_point(aes(color=Species), size=10) + 
     scale_colour_iwanthue()
    
   ggplot(iris, aes(x=Petal.Width, y=Petal.Length)) +
     geom_point(aes(color=Species), size=10) + 
     scale_colour_iwanthue(hmax = 90)
     
}
}
\author{
Russell Dinnage \href{mailto:r.dinnage@gmail.com}{r.dinnage@gmail.com}
}
