% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-round_ids.R
\name{get_round_idx}
\alias{get_round_idx}
\alias{get_round_ids}
\title{Utilities for accessing round ID metadata}
\usage{
get_round_idx(config_tasks, round_id)

get_round_ids(
  config_tasks,
  flatten = c("all", "model_task", "task_id", "none")
)
}
\arguments{
\item{config_tasks}{a list version of the content's of a hub's \code{tasks.json}
config file, accessed through the \code{"config_tasks"} attribute of a \verb{<hub_connection>}
object or function \code{\link[=read_config]{read_config()}}.}

\item{round_id}{Character string. Round identifier. If the round is set to
\code{round_id_from_variable: true}, IDs are values of the task ID defined in the
round's \code{round_id} property of \code{config_tasks}.
Otherwise should match round's \code{round_id} value in config. Ignored if hub
contains only a single round.}

\item{flatten}{Character. Whether and how much to flatten output.
\itemize{
\item \code{"all"}: Complete flattening.
Returns a character vector of unique round IDs across all rounds.
\item \code{"model_task"}: Flatten model tasks.
Returns a list with an element for each round.
Each round element contains a character vector of unique round IDs
across all round model tasks.
Only applicable if \code{round_id_from_variable} is \code{TRUE}.
\item \code{"task_id"}: Flatten task ID.
Returns a nested list with an element for each round.
Each round element contains a list with an element for each model task.
Each model task element contains a character vector of unique round IDs.
across \code{required} and \code{optional} properties.
Only applicable if \code{round_id_from_variable} is \code{TRUE}
\item \code{"none"}: No flattening.
If \code{round_id_from_variable} is \code{TRUE},
returns a nested list with an element for each round.
Each round element contains a nested element for each model task.
Each model task element contains a nested list of \code{required} and \code{optional}
character vectors of round IDs.
If \code{round_id_from_variable} is \code{FALSE},a list with a round ID for each round
is returned.
}}
}
\value{
the integer index of the element in \code{config_tasks$rounds} that a
character round identifier maps to

a list or character vector of hub round IDs
\itemize{
\item A character vector is returned only if \code{flatten = "all"}
\item A list is returned otherwise (see \code{flatten} for more details)
}
}
\description{
Utilities for accessing round ID metadata
}
\section{Functions}{
\itemize{
\item \code{get_round_idx()}: Get an integer index of the element in
\code{config_tasks$rounds} that a character round identifier maps to.

\item \code{get_round_ids()}: Get a list or character vector of hub round IDs.
For each round, if \code{round_id_from_variable} is \code{TRUE}, round IDs returned are
the values of the task ID defined in the \code{round_id} property. Otherwise, if
\code{round_id_from_variable} is \code{FALSE}, the value of the \code{round_id} property is
returned.

}}
\examples{
config_tasks <- read_config(
  hub_path = system.file("testhubs/simple", package = "hubUtils")
)
# Get round IDs
get_round_ids(config_tasks)
get_round_ids(config_tasks, flatten = "model_task")
get_round_ids(config_tasks, flatten = "task_id")
get_round_ids(config_tasks, flatten = "none")
# Get round integer index using a round_id
get_round_idx(config_tasks, "2022-10-01")
get_round_idx(config_tasks, "2022-10-29")
}
