test_that("NBA League Standings", {
  skip_on_cran()
  skip_on_ci()

  x <- nba_leaguestandings(league_id = "00", season = year_to_season(most_recent_nba_season() - 1))

  cols_x1 <- c(
    "LeagueID",
    "SeasonID",
    "TeamID",
    "TeamCity",
    "TeamName",
    "Conference",
    "ConferenceRecord",
    "PlayoffRank",
    "ClinchIndicator",
    "Division",
    "DivisionRecord",
    "DivisionRank",
    "WINS",
    "LOSSES",
    "WinPCT",
    "LeagueRank",
    "Record",
    "HOME",
    "ROAD",
    "L10",
    "Last10Home",
    "Last10Road",
    "OT",
    "ThreePTSOrLess",
    "TenPTSOrMore",
    "LongHomeStreak",
    "strLongHomeStreak",
    "LongRoadStreak",
    "strLongRoadStreak",
    "LongWinStreak",
    "LongLossStreak",
    "CurrentHomeStreak",
    "strCurrentHomeStreak",
    "CurrentRoadStreak",
    "strCurrentRoadStreak",
    "CurrentStreak",
    "strCurrentStreak",
    "ConferenceGamesBack",
    "DivisionGamesBack",
    "ClinchedConferenceTitle",
    "ClinchedDivisionTitle",
    "ClinchedPlayoffBirth",
    "EliminatedConference",
    "EliminatedDivision",
    "AheadAtHalf",
    "BehindAtHalf",
    "TiedAtHalf",
    "AheadAtThird",
    "BehindAtThird",
    "TiedAtThird",
    "Score100PTS",
    "OppScore100PTS",
    "OppOver500",
    "LeadInFGPCT",
    "LeadInReb",
    "FewerTurnovers",
    "PointsPG",
    "OppPointsPG",
    "DiffPointsPG",
    "vsEast",
    "vsAtlantic",
    "vsCentral",
    "vsSoutheast",
    "vsWest",
    "vsNorthwest",
    "vsPacific",
    "vsSouthwest",
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "May",
    "Jun",
    "Jul",
    "Aug",
    "Sep",
    "Oct",
    "Nov",
    "Dec",
    "PreAS",
    "PostAS"
  )

  expect_equal(sort(colnames(x[[1]])), sort(cols_x1))
  expect_s3_class(x[[1]], "data.frame")

  Sys.sleep(3)

})
