% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_shotchart.R
\name{nba_shotchartleaguewide}
\alias{nba_shotchartleaguewide}
\title{\strong{Get NBA Stats API Shot Chart League-Wide}}
\usage{
nba_shotchartleaguewide(
  league_id = "00",
  season = year_to_season(most_recent_nba_season() - 1),
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{season}{season}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: League_Wide

\strong{League_Wide}\tabular{ll}{
   col_name \tab types \cr
   GRID_TYPE \tab character \cr
   SHOT_ZONE_BASIC \tab character \cr
   SHOT_ZONE_AREA \tab character \cr
   SHOT_ZONE_RANGE \tab character \cr
   FGA \tab character \cr
   FGM \tab character \cr
   FG_PCT \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Shot Chart League-Wide}

\strong{Get NBA Stats API Shot Chart League-Wide}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_shotchartleaguewide(league_id = '00', season = year_to_season(most_recent_nba_season() - 1))
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Shooting Functions: 
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashteamptshot}()},
\code{\link{nba_leaguedashteamshotlocations}()},
\code{\link{nba_playerdashboardbyshootingsplits}()},
\code{\link{nba_shotchartdetail}()},
\code{\link{nba_shotchartlineupdetail}()},
\code{\link{nba_teamdashboardbyshootingsplits}()}

Other NBA League Functions: 
\code{\link{nba_leaguedashlineups}()},
\code{\link{nba_leaguedashoppptshot}()},
\code{\link{nba_leaguedashplayerbiostats}()},
\code{\link{nba_leaguedashplayerclutch}()},
\code{\link{nba_leaguedashplayerptshot}()},
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashplayerstats}()},
\code{\link{nba_leaguedashptdefend}()},
\code{\link{nba_leaguedashptstats}()},
\code{\link{nba_leaguedashptteamdefend}()},
\code{\link{nba_leaguedashteamclutch}()},
\code{\link{nba_leaguedashteamptshot}()},
\code{\link{nba_leaguedashteamshotlocations}()},
\code{\link{nba_leaguedashteamstats}()},
\code{\link{nba_leaguegamefinder}()},
\code{\link{nba_leaguegamelog}()},
\code{\link{nba_leaguelineupviz}()},
\code{\link{nba_leagueplayerondetails}()},
\code{\link{nba_leagueseasonmatchups}()},
\code{\link{nba_leaguestandingsv3}()},
\code{\link{nba_leaguestandings}()},
\code{\link{nba_matchupsrollup}()},
\code{\link{nba_playoffpicture}()}
}
\author{
Saiem Gilani
}
\concept{NBA League Functions}
\concept{NBA Shooting Functions}
