test_that("tmr_elapsed", {
  tmr <- tmr_timer()
  expect_identical(tmr_elapsed(tmr), tmr)
  tmr <- tmr_start(tmr)
  sys_time <- as.numeric(Sys.time())
  expect_gte(attr(tmr_elapsed(tmr), "start"), sys_time)
  expect_true(tmr_is_started(tmr))
  elapsed <- tmr_elapsed(tmr)
  expect_lte(tmr_elapsed(elapsed), tmr_elapsed(tmr))
  expect_lte(tmr_elapsed(tmr), tmr_elapsed(elapsed))
  Sys.sleep(1)
  tmr <- tmr_stop(tmr)
  expect_gte(as.numeric(tmr), 1)
  expect_identical(tmr_elapsed(tmr), tmr)
})
