% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_hmsid.R
\name{theme_hmsid}
\alias{theme_hmsid}
\title{Custom ggplot2 theme function}
\usage{
theme_hmsid(
  base_size,
  text_size,
  subtitle_size,
  subtitle_margin,
  plot_title_size,
  plot_title_margin,
  ...
)
}
\arguments{
\item{base_size}{base font size}

\item{text_size}{plot text size}

\item{subtitle_size, subtitle_margin}{plot subtitle size and margin}

\item{plot_title_size, plot_title_margin}{plot title size and margin}

\item{...}{Other arguments passed to \code{theme_hmsid}}
}
\value{
A customized theme for a ggplot object.
}
\description{
Custom ggplot2 theme function
}
\examples{
library(ggplot2)
dat <- data.frame(
  x = seq_along(1:5),
  y = rnorm(n = 5, mean = 0.5, sd = 1)
)
dat |>
  ggplot(aes(x = x, y = y)) +
  geom_line() +
  hmsidwR::theme_hmsid()

}
