% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histoslider.R
\name{update_histoslider}
\alias{update_histoslider}
\title{Update a histogram slider}
\usage{
update_histoslider(
  id,
  label = NULL,
  values = NULL,
  start = NULL,
  end = NULL,
  breaks = rlang::missing_arg(),
  options = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{id}{An input id.}

\item{label}{A label for the input (can be \code{NULL} or a string).}

\item{values}{a vector of numeric values for which the histogram is desired.}

\item{start}{A numeric value for the starting handle.}

\item{end}{A numeric value for the ending handle.}

\item{breaks}{determines how histogram bins are computed (see \code{\link[=hist]{hist()}} for
possible values and details).}

\item{options}{a list of \href{https://github.com/samhogg/histoslider/blob/b4ac504/src/components/Histoslider.js#L103-L125}{histoslider options}.}

\item{session}{The shiny user \code{session} object.}
}
\value{
Nothing.
}
\description{
Change the value of a \code{\link[=input_histoslider]{input_histoslider()}} on the client (must be called
inside a currently active user \code{session}). See
\href{https://github.com/cpsievert/histoslider/blob/main/inst/examples/update/app.R}{here}
for an example.
}
\details{
Any arguments with \code{NULL} values will be ignored; they will not
result in any changes to the input object on the client.
}
\seealso{
\link{input_histoslider}
}
