% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlighted_text.R
\name{highlighted_text}
\alias{highlighted_text}
\title{Create Highlighted Testimony}
\usage{
highlighted_text(plot_object, labels = c("", ""))
}
\arguments{
\item{plot_object}{plot object resulting from \code{\link[=collocation_plot]{collocation_plot()}}}

\item{labels}{lower and upper labels for the gradient scale}
}
\value{
html code for highlighted text
}
\description{
Adds html tags to create a highlighted testimony corresponding to word frequency.
To render correctly, the object produced from \code{highlighted_text()} can be added outside of a code chunk in an .Rmd document in the \code{`r highlighted_text()`} format.
Alternatively, the html output can be saved by using the \code{xml2} package as follows:
\code{xml2::write_html(xml2::read_html(highlighted_text(), "filepath.html"))}
}
\examples{
# Rename relevant column to page_notes in the derivative document
comment_example_rename <- dplyr::rename(comment_example, page_notes=Notes)
# Tokenize the derivative document
toks_comment <- token_comments(comment_example_rename)
# Rename relevant column in the source document to text
transcript_example_rename <- dplyr::rename(transcript_example, text=Text)
# Tokenize source document
toks_transcript <- token_transcript(transcript_example_rename)
# Compute collocation frequencies
collocation_object <- collocate_comments(toks_transcript, toks_comment)
# Merge frequencies with source document to provide averages by word and correct formatting
merged_frequency <- transcript_frequency(transcript_example_rename, collocation_object)
# Create a plot object to assign colors based on frequency
freq_plot <- collocation_plot(merged_frequency)
# Add html tags to create a highlighted version of the source document
page_highlight <- highlighted_text(freq_plot, merged_frequency)
}
