% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hSet.R, R/hierarchicalSet.R
\name{create_hierarchy}
\alias{create_hierarchy}
\alias{HierarchicalSet}
\alias{print.HierarchicalSet}
\alias{[[.HierarchicalSet}
\alias{[.HierarchicalSet}
\alias{sets.HierarchicalSet}
\alias{clusters.HierarchicalSet}
\alias{set_names.HierarchicalSet}
\alias{element_names.HierarchicalSet}
\alias{n_sets.HierarchicalSet}
\alias{length.HierarchicalSet}
\alias{n_elements.HierarchicalSet}
\alias{n_clusters.HierarchicalSet}
\alias{cluster_sizes.HierarchicalSet}
\alias{set_sizes.HierarchicalSet}
\alias{cluster_members.HierarchicalSet}
\alias{set_membership.HierarchicalSet}
\title{Create and store hierarchcical sets}
\usage{
create_hierarchy(sets, intersectLimit = 1)

\method{print}{HierarchicalSet}(x, ...)

\method{[[}{HierarchicalSet}(x, i)

\method{[}{HierarchicalSet}(x, i)

\method{sets}{HierarchicalSet}(x)

\method{clusters}{HierarchicalSet}(x)

\method{set_names}{HierarchicalSet}(x)

\method{element_names}{HierarchicalSet}(x)

\method{n_sets}{HierarchicalSet}(x)

\method{length}{HierarchicalSet}(x)

\method{n_elements}{HierarchicalSet}(x)

\method{n_clusters}{HierarchicalSet}(x)

\method{cluster_sizes}{HierarchicalSet}(x)

\method{set_sizes}{HierarchicalSet}(x)

\method{cluster_members}{HierarchicalSet}(x)

\method{set_membership}{HierarchicalSet}(x)
}
\arguments{
\item{sets}{The sets to analyse. Can either be a matrix/data.frame giving the
presence/absence pattern of elements, with elements as rows and sets as
columns, or a list of vectors giving the elements of the individual sets.}

\item{intersectLimit}{The proportion of sets an element must be present in to
be considered part of the intersect. Standard intersects require it to be
present in all sets (\code{intersectLimit = 1}), which is also the default}

\item{x}{A HierarchicalSet object}

\item{...}{Currently ignored}

\item{i}{The index of the dendrogram}
}
\value{
An object of class HierarchicalSet
}
\description{
HierarchicalSet object can be created using the \code{hSet()} constructor.
The resulting object will contain both the underlying sets as well as the
resulting clustering.
}
\details{
The HierarchicalSet class contains both the clustering and the original sets.
The former is stored in a list of dendrogram objects in and the latter as a
presence/absence matrix. Both are retrivable using \verb{$clusters} and
\verb{$sets} respectively. Furthermore individual dendrograms can be
extracted directly using the \code{[[} operator. If multiple independent
clusters exists the object can be subsetted using the \code{[} operator.

For plotting functionality see the separate plot documentation for
\code{\link[=plot.HierarchicalSet]{plot.HierarchicalSet()}}.
}
\section{Functions}{
\itemize{
\item \code{print(HierarchicalSet)}: Print method for HierarchicalSet objects

\item \code{[[}: Extract dendrogram objects from HierarchicalSet objects

\item \code{[}: Subset HierarchicalSet object by dendrogram (preserving set
information and class)

\item \code{sets(HierarchicalSet)}: Extract the sets as a sparse matrix

\item \code{clusters(HierarchicalSet)}: Extract the clusters as a list of dendrograms

\item \code{set_names(HierarchicalSet)}: Get the names of the sets

\item \code{element_names(HierarchicalSet)}: Get the names of the elements

\item \code{n_sets(HierarchicalSet)}: Get the number of sets

\item \code{length(HierarchicalSet)}: Get the number of sets

\item \code{n_elements(HierarchicalSet)}: Get the number of elements

\item \code{n_clusters(HierarchicalSet)}: Get the number of clusters

\item \code{cluster_sizes(HierarchicalSet)}: Get the size of each clusters

\item \code{set_sizes(HierarchicalSet)}: Get the size of each set

\item \code{cluster_members(HierarchicalSet)}: Get the members of each clusters

\item \code{set_membership(HierarchicalSet)}: Get the membership of each set

}}
\examples{
data('twitter')

# Caclulate the clustering
twitSet <- create_hierarchy(twitter)

# Some statistics on the data
n_sets(twitSet)
n_elements(twitSet)
n_clusters(twitSet)

# Focus on the first two independent cluster
twitSet[1:2]

# Extract a dendrogram representation of the firrst cluster
twitSet[[1]]

}
