% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_grid.R
\name{dgverify}
\alias{dgverify}
\title{Verify grid object}
\usage{
dgverify(dggs)
}
\arguments{
\item{dggs}{Grid object to verify (from hexify_grid)}
}
\value{
TRUE (invisibly) if valid, otherwise throws an error
}
\description{
Validates that a grid object has all required fields and valid values.
This function is called internally by most hexify functions to ensure
grid integrity.
}
\examples{
grid <- hexify_grid(area = 1000, aperture = 3)
dgverify(grid)  # Should pass silently

# Invalid grid will throw error
bad_grid <- list(aperture = 5)
try(dgverify(bad_grid))  # Will error
}
