% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{hyperSharperQ}
\alias{hyperSharperQ}
\title{Hypervolume Sharpe ratio return and covariance}
\usage{
hyperSharperQ(A, l, u)
}
\arguments{
\item{A}{matrix of assets, in R^p}

\item{l, u}{vector of lower and upper bounds in R^p}
}
\value{
list with the return vector r and the covariance Q.
}
\description{
Hypervolume Sharpe ratio return and covariance
}
\examples{
################################################################################
### 2 objectives example
################################################################################
A <- matrix(runif(20*2),20)
res <- hyperSharperQ(A = A, l = c(0,0), u = c(1,1))
plot(A, pch = 20, xlim = c(0,1), ylim = c(0,1))
}
\references{
A. P. Guerreiro, C. M. Fonseca,
Hypervolume Sharpe-Ratio indicator: Formalization and first theoretical results,
International Conference on Parallel Problem Solving from Nature, 2016, 814-823.
}
