% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hai-skewed-features.R
\name{hai_skewed_features}
\alias{hai_skewed_features}
\title{Get Skewed Feature Columns}
\usage{
hai_skewed_features(.data, .threshold = 0.6, .drop_keys = NULL)
}
\arguments{
\item{.data}{The data.frame/tibble you are passing in.}

\item{.threshold}{A level of skewness that indicates where you feel a column
should be considered skewed.}

\item{.drop_keys}{A c() character vector of columns you do not want passed to
the function.}
}
\value{
A character vector of column names that are skewed.
}
\description{
Takes in a data.frame/tibble and returns a vector of names of
the columns that are skewed.
}
\details{
Takes in a data.frame/tibble and returns a vector of names of the skewed
columns. There are two other parameters. The first is the \code{.threshold} parameter
that is set to the level of skewness you want in order to consider the column
too skewed. The second is \code{.drop_keys}, these are columns you don't want to be
considered for whatever reason in the skewness calculation.
}
\examples{
hai_skewed_features(mtcars)
hai_skewed_features(mtcars, .drop_keys = c("mpg", "hp"))
hai_skewed_features(mtcars, .drop_keys = "hp")

}
\author{
Steven P. Sandeson II, MPH
}
