/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5FDmodule.h" 

#include "H5private.h" 

#ifdef H5_HAVE_WINDOWS

#include "H5Eprivate.h"  
#include "H5FDsec2.h"    
#include "H5FDpkg.h"     
#include "H5FDwindows.h" 
#include "H5Pprivate.h"  

herr_t
H5Pset_fapl_windows(hid_t fapl_id)
{
    H5P_genplist_t *plist; 
    herr_t          ret_value;

    FUNC_ENTER_API(FAIL)

    if (NULL == (plist = H5P_object_verify(fapl_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a file access property list");

    ret_value = H5P_set_driver(plist, H5FD_WINDOWS, NULL, NULL);

done:
    FUNC_LEAVE_API(ret_value)
} 

#endif 
