% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_mxPBF.R
\name{mxPBF_mean}
\alias{mxPBF_mean}
\title{Change Point Detection in Mean Structure using Maximum Pairwise Bayes Factor (mxPBF)}
\usage{
mxPBF_mean(given_data, nws, alps, FPR_want = 0.05, n_sample = 300, n_cores = 1)
}
\arguments{
\item{given_data}{An \eqn{(n \times p)} data matrix representing \eqn{n} observations and \eqn{p} variables.}

\item{nws}{A set of window sizes for change point detection.}

\item{alps}{A grid of alpha values used in the empirical False Positive Rate (FPR) method.}

\item{FPR_want}{Desired False Positive Rate for selecting alpha, used in the empirical FPR method (default: 0.05).}

\item{n_sample}{Number of simulated samples to estimate the empirical FPR, used in the empirical FPR method (default: 300).}

\item{n_cores}{Number of threads for parallel execution via OpenMP (default: 1).}
}
\value{
A list of length equal to the number of window sizes provided. Each element in the list contains: \describe{
\item{Change_points}{Locations of detected change points.}
\item{Bayes_Factors}{Vector of calculated Bayes Factors for each middle points.}
\item{Selected_alpha}{Optimal alpha value selected based on the method that controls the empirical FPR.}
\item{Window_size}{Window size used for change point detection.}
}
}
\description{
This function detects change points in the mean structure of multivariate Gaussian data using the Maximum Pairwise Bayes Factor (mxPBF).
The function selects alpha that controls the empirical False Positive Rate (FPR), as suggested in the paper.
One can conduct a multiscale approach using the function \code{majority_rule_mxPBF()}.
}
\examples{
\donttest{
nws <- c(25, 60, 100)
alps <- seq(1,10,0.05)
## H0 data
mu1 <- rep(0,10)
sigma <- diag(10)
X <- mvrnorm_cpp(500, mu1, sigma)
res1 <- mxPBF_mean(X, nws, alps)

## H1 data
mu2 <- rep(1,10)
sigma <- diag(10)
Y <- rbind(mvrnorm_cpp(250,mu1,sigma), mvrnorm_cpp(250,mu2,sigma))
res2 <- mxPBF_mean(Y, nws, alps)
}

}
