% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aft_stratified_pp.R
\name{aft.stratified.pp}
\alias{aft.stratified.pp}
\title{Posterior of stratified power prior (PP) with fixed \eqn{a_0}}
\usage{
aft.stratified.pp(
  formula,
  data.list,
  strata.list,
  a0.strata,
  dist = "weibull",
  beta.mean = NULL,
  beta.sd = NULL,
  scale.mean = NULL,
  scale.sd = NULL,
  get.loglik = FALSE,
  iter_warmup = 1000,
  iter_sampling = 1000,
  chains = 4,
  ...
)
}
\arguments{
\item{formula}{a two-sided formula giving the relationship between the response variable and covariates.
The response is a survival object as returned by the \code{survival::Surv(time, event)} function,
where event is a binary indicator for event (0 = no event, 1 = event has occurred). The type of
censoring is assumed to be right-censoring.}

\item{data.list}{a list of \code{data.frame}s. The first element in the list is the current data, and the rest
are the historical data sets. For fitting accelerated failure time (AFT) models, all historical
data sets will be stacked into one historical data set.}

\item{strata.list}{a list of vectors specifying the stratum ID for each observation in the corresponding data set
in \code{data.list}. The first element in the list corresponds to the current data, and the rest
correspond to the historical data sets. Each vector should have the same length as the number
of rows in the respective data set in \code{data.list}, with values representing stratum labels
as positive integers (e.g., 1, 2, 3, ...).}

\item{a0.strata}{A scalar or a vector of fixed power prior parameters (\eqn{a_0}'s) for each stratum, with values
between 0 and 1. If a scalar is provided, it will be replicated for all strata. If a vector is
provided, its length must match the total number of unique strata across all data sets. The first
element of \code{a0.strata} corresponds to stratum 1, the second to stratum 2, and so on.}

\item{dist}{a character indicating the distribution of survival times. Currently, \code{dist} can be one of the
following values: "weibull", "lognormal", or "loglogistic". Defaults to "weibull".}

\item{beta.mean}{a scalar or a vector whose dimension is equal to the number of regression coefficients giving
the mean parameters for the initial prior on regression coefficients. If a scalar is provided,
\code{beta.mean} will be a vector of repeated elements of the given scalar. Defaults to a vector of 0s.}

\item{beta.sd}{a scalar or a vector whose dimension is equal to the number of regression coefficients giving
the sd parameters for the initial prior on regression coefficients. If a scalar is provided,
same as for \code{beta.mean}. Defaults to a vector of 10s.}

\item{scale.mean}{location parameter for the half-normal prior on the scale parameter of the AFT model. Defaults to 0.}

\item{scale.sd}{scale parameter for the half-normal prior on the scale parameter of the AFT model. Defaults to 10.}

\item{get.loglik}{whether to generate log-likelihood matrix. Defaults to FALSE.}

\item{iter_warmup}{number of warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_warmup} in
\code{sample()} method in cmdstanr package.}

\item{iter_sampling}{number of post-warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_sampling}
in \code{sample()} method in cmdstanr package.}

\item{chains}{number of Markov chains to run. Defaults to 4. See the argument \code{chains} in \code{sample()} method in
cmdstanr package.}

\item{...}{arguments passed to \code{sample()} method in cmdstanr package (e.g., \code{seed}, \code{refresh}, \code{init}).}
}
\value{
The function returns an object of class \code{draws_df} containing posterior samples. The object has two attributes:

\describe{
\item{data}{a list of variables specified in the data block of the Stan program}

\item{model}{a character string indicating the model name}
}
}
\description{
Sample from the posterior distribution of an accelerated failure time (AFT) model using the power prior (PP) within
predefined strata. If the strata and power prior parameters (\eqn{a_0}'s) are determined based on propensity scores,
this function can be used to sample from the posterior of an AFT model under the propensity score-integrated power
prior (PSIPP) by Wang et al. (2019) \url{doi:10.1080/10543406.2019.1657133}.
}
\details{
The power prior parameters (\eqn{a_0}'s) are treated as fixed and must be provided for each stratum. Users must
also specify the stratum ID for each observation. Within each stratum, the initial priors on the regression
coefficients are independent normal priors, and the current and historical data models are assumed to have a common
scale parameter with a half-normal prior.
}
\examples{
if (instantiate::stan_cmdstan_exists()) {
  if(requireNamespace("survival")){
    library(survival)
    data(E1684)
    data(E1690)
    ## take subset for speed purposes
    E1684 = E1684[1:100, ]
    E1690 = E1690[1:50, ]
    ## replace 0 failure times with 0.50 days
    E1684$failtime[E1684$failtime == 0] = 0.50/365.25
    E1690$failtime[E1690$failtime == 0] = 0.50/365.25
    data_list = list(currdata = E1690, histdata = E1684)
    strata_list = list(rep(1:2, each = 25), rep(1:2, each = 50))
    # Alternatively, we can determine the strata based on propensity scores
    # using the psrwe package, which is available on GitHub
    aft.stratified.pp(
      formula = survival::Surv(failtime, failcens) ~ treatment,
      data.list = data_list,
      strata.list = strata_list,
      a0.strata = c(0.3, 0.5),
      dist = "weibull",
      chains = 1, iter_warmup = 500, iter_sampling = 1000
    )
  }
}
}
\references{
Wang, C., Li, H., Chen, W.-C., Lu, N., Tiwari, R., Xu, Y., & Yue, L. Q. (2019). Propensity score-integrated power prior approach for incorporating real-world evidence in single-arm clinical studies. Journal of Biopharmaceutical Statistics, 29(5), 731–748.
}
