% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist.R
\name{hist_interim}
\alias{hist_interim}
\title{Adjust a design based on historical controls at interim using the covariate data of the patients accrued in stage 1.}
\usage{
hist_interim(start, stageone_data)
}
\arguments{
\item{start}{An initialized design based on historical controls as returned by \code{hist_start()}.}

\item{stageone_data}{A dataframe containing the relevant covariate data of the patients accrued in stage 1.}
}
\value{
A list returning the arguments of the function and the preliminary design of a trial based on historical controls adjusted at interim.
}
\description{
Adjust a design based on historical controls at interim using the covariate data of the patients accrued in stage 1.
}
\examples{
X <- abs(rnorm(1000, 0, 1))
Y <- rbinom(1000, 1, 1-exp(-X))
mydata <- data.frame("X" = X, "Y" = Y)
start <- hist_start(mydata, Y~X, c1 = 2)
n1 <- start$des_start[2]
X1 <- abs(rnorm(n1, 0, 1))
dataone <- data.frame("X" = X1)
hist_interim(start, dataone)
}
