% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hchinamap.R
\name{hchinamap}
\alias{hchinamap}
\title{'hchinamap': Mapping China and Its Provinces, Municipalities and Autonomous Regions using R and 'Highmaps'}
\usage{
hchinamap(name, value, region = "China", width = NULL, height = NULL,
  elementId = NULL, itermName = "Random data", title = "",
  titleAlign = "center", titleSize = "20px", titleColor = "#333333",
  subtitle = "", subtitleAlign = "center", subtitleSize = "",
  subtitleColor = "#666666", min = 0, minColor = "rgb(255,255,255)",
  maxColor = "#006cee", legendLayout = "horizontal",
  legendAlign = "center", legendTitle = "",
  legendVerticalAlign = "bottom", hoverColor = "#a4edba",
  theme = "sunset")
}
\arguments{
\item{name}{Chinese name vector of provinces or prefecture-level cities in China.}

\item{value}{Value vector;}

\item{region}{Region name in English, Such as "China", "Anhui" ...;}

\item{width}{Chart width;}

\item{height}{Chart height;}

\item{elementId}{NULL}

\item{itermName}{Data attributes in tooltip;}

\item{title}{Chart title;}

\item{titleAlign}{The horizontal position of the title, such as "center";}

\item{titleSize}{The size of the title, such as "20px";}

\item{titleColor}{The color of the title, such as "#3333";}

\item{subtitle}{Subtitle of chart;}

\item{subtitleAlign}{The horizontal position of subtitles, such as "center";}

\item{subtitleSize}{The size of the subtitle, such as "16px";}

\item{subtitleColor}{The color of the subtitle, such as "#666666";}

\item{min}{The minimum value of legend, 0 by default.}

\item{minColor}{The color corresponding to the minimum of the legend, such as "white";}

\item{maxColor}{The color corresponding to the maximum value of the legend, such as "#006cee";}

\item{legendLayout}{Legend, horizontal or vertical;}

\item{legendAlign}{Horizontal position of legend, center/left/right;}

\item{legendTitle}{The title of the legend;}

\item{legendVerticalAlign}{The vertical position of legends, top/center/bottom;}

\item{hoverColor}{The color of the area when the mouse is hovering.}

\item{theme}{Chart theme, you can choose one from:
darkgreen/darkblue/avocado/darkunica/gray/
gridlight/grid/sandsignika/sunset;}
}
\description{
By binding R functions and the 'Highmaps' <https://www.highcharts.com.cn/products/highmaps> chart library,'hchinamap' package provides a simple way to map China and its provinces. The map of China drawn by this package contains complete Chinese territory, especially the Nine-dotted line, South Tibet, Hong Kong, Macao and Taiwan.
}
\note{
Because the map data of Taiwan have not been collated yet, it is impossible to draw provincial map of Taiwan Province for the time being.
}
\examples{
library(hchinamap)
library(dplyr)
library(magrittr)
dir <- tempdir()
download.file('https://czxb.github.io/br/chinadf.rda', file.path(dir, 'chinadf.rda'))
load(file.path(dir, 'chinadf.rda'), verbose = TRUE)
china <- chinadf \%>\%
  dplyr::filter(region == "China")
if(interactive()) {
   hchinamap(name = china$name, value = china$value, region = "China")
}

}
